import { exPairApply, coinType, ormDB, systemTrigger, spotPairs, exTradeArea, exBusinessAreaRouter } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";
import { addCoin2Core, addPairToCore } from "../../../utils/coreSystemUtils";
import { PAIR_APPLY_STATUS } from "../../../constant/pairApplyConst";


let _ = require('lodash');
let { logger, datetimeUtils } = require('@madex/ex-js-public');


export interface PairApplyVO {
    id?: number;

    coin_symbol?: string;

    currency_symbol?: string;

    maker_rate?: string;

    taker_rate?: string;

    pair_type?: number;

    area_id?: number;

    business_area_id?: number;

    decimal?: number;

    qtyPrecision?: number;

    weight?: number;

    tm_active?: Date | any;

    baseMinValue?: string;

    baseMaxValue?: string;

    quoteMinValue?: string;

    quoteMaxValue?: string;

    quoteIncrement?: string;

    applyer?: number;

    checker?: number;

    status?: number;

    reason?: string;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface PairApplyPageVO extends PairApplyVO {

    page?: number,

    size?: number,

    symbol?: string;

    is_active?: number;
}


export async function list(pageVO: PairApplyPageVO) {

    let resList = await exPairApply.prototype.findAndCount({
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [['status', 'asc'], ["id", "desc"]],
        raw: true
    });
    return resList;
}

export async function listed(pageVO: PairApplyPageVO) {
    let where = {};
    if (pageVO.symbol) {
        where['symbol'] = pageVO.symbol;
    }
    //TODO:是否查询此表 还是ex_pair ???
    let resList = await spotPairs.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export async function tradeAreaList(pageVO: PairApplyPageVO) {

    let where = {};
    if (pageVO.coin_symbol) {
        where['coin_symbol'] = pageVO.coin_symbol;
    }
    if (pageVO.is_active || pageVO.is_active === 0) {
        where['is_active'] = pageVO.is_active;
    }
    let resList = await exTradeArea.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


export async function apply(pairApplyVO: PairApplyVO, currentUser: any, ip: string | undefined) {


    let dbSymbol = await coinType.prototype.findOne({
        where: { symbol: pairApplyVO.coin_symbol },
        raw: true
    });
    if (!dbSymbol) {
        throw ErrorCode.COIN_DATA_NOT_EXIST;
    }

    let dbCurrency = await coinType.prototype.findOne({
        where: { symbol: pairApplyVO.currency_symbol },
        raw: true
    });
    if (!dbCurrency) {
        throw ErrorCode.CURRENT_COIN_DATA_NOT_EXIST;
    }
    pairApplyVO.maker_rate = "0.001";
    pairApplyVO.taker_rate = "0.002";
    pairApplyVO.baseMaxValue = "100000000";
    pairApplyVO.quoteMaxValue = "100000000";

    pairApplyVO.applyer = currentUser.account;
    pairApplyVO.status = PAIR_APPLY_STATUS.WAIT_VIEW;
    pairApplyVO.createdAt = new Date();
    pairApplyVO.updatedAt = new Date();
    if (Number(pairApplyVO.id) > 0) {//update
        let dbApply = await exPairApply.prototype.findOne({
            where: { id: pairApplyVO.id },
            raw: true
        });
        if (!dbApply) {
            throw ErrorCode.DATA_NOT_EXIST;
        }
        if (dbApply.status != PAIR_APPLY_STATUS.RE_WRITE) {
            throw ErrorCode.NOT_EDIT
        }
        await exPairApply.prototype.update(pairApplyVO, {
            where: {
                id: Number(pairApplyVO.id)
            }
        });
    }
    else {
        await exPairApply.prototype.create(pairApplyVO);
    }
    sendMsg(pairApplyVO.status, pairApplyVO.coin_symbol + '_' + pairApplyVO.currency_symbol);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '新增上新交易对申请', ip, JSON.stringify(pairApplyVO), '交易上下线管理');
    return 'success';
}


export async function edit(pairApplyVO: PairApplyVO, currentUser: any, ip: string | undefined) {

    let dbApply = await exPairApply.prototype.findOne({
        where: { id: pairApplyVO.id },
        raw: true
    });
    if (!dbApply) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    if (Number(pairApplyVO.status) >= PAIR_APPLY_STATUS.CREATE_PAIR) {
        let dbSymbol = await coinType.prototype.findOne({
            where: { symbol: pairApplyVO.coin_symbol },
            raw: true
        });
        if (!dbSymbol) {
            throw ErrorCode.COIN_DATA_NOT_EXIST;
        }
        let dbCurrency = await coinType.prototype.findOne({
            where: { symbol: pairApplyVO.currency_symbol },
            raw: true
        });
        if (!dbCurrency) {
            throw ErrorCode.CURRENT_COIN_DATA_NOT_EXIST;
        }
    }
    pairApplyVO.applyer = dbApply.applyer;
    pairApplyVO.updatedAt = new Date();

    await exPairApply.prototype.update(pairApplyVO, {
        where: {
            id: Number(pairApplyVO.id)
        }
    });
    sendMsg(Number(pairApplyVO.status), pairApplyVO.coin_symbol + '_' + pairApplyVO.currency_symbol);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '上新交易对申请编辑', ip, JSON.stringify(pairApplyVO), '交易上下线管理');
    return 'success';
}

export async function cancelSelf(id: any, reason: any, currentUser: any, ip: string | undefined) {

    let dbApply = await exPairApply.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbApply) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    if (dbApply.status >= PAIR_APPLY_STATUS.PASS) {
        throw ErrorCode.NO_CANCEL;
    }
    await updateApply(Number(id), PAIR_APPLY_STATUS.CANCEL, currentUser.account, String(reason), dbApply.coin_symbol, dbApply.currency_symbol);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '撤销上新交易对申请', ip, JSON.stringify(dbApply), '交易上下线管理');
    return 'success';
}

export async function rewrite(id: any, reason: any, currentUser: any, ip: string | undefined) {

    let dbApply = await exPairApply.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbApply) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    await updateApply(Number(id), PAIR_APPLY_STATUS.RE_WRITE, currentUser.account, String(reason), dbApply.coin_symbol, dbApply.currency_symbol);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '驳回上新交易对申请', ip, JSON.stringify(dbApply), '交易上下线管理');
    return 'success';
}

export async function cancel(id: any, reason: any, currentUser: any, ip: string | undefined) {

    let dbApply = await exPairApply.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbApply) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    await updateApply(Number(id), PAIR_APPLY_STATUS.CANCEL, currentUser.account, String(reason), dbApply.coin_symbol, dbApply.currency_symbol);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '管理员取消上新交易对申请', ip, JSON.stringify(dbApply), '交易上下线管理');
    return 'success';
}

export async function review(id: any, currentUser: any, ip: string | undefined) {

    let dbApply = await exPairApply.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbApply) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    let reason = "";
    //1被驳回 2申请待审批 3审批通过 4交易对创建完成 5交易对增加到撮合完成 6等待撮合系统重启 7发布交易对到撮合完成 8交易对激活定时器完成 9取消
    let status = Number(dbApply.status)
    let pair = dbApply.coin_symbol + '_' + dbApply.currency_symbol;
    if (status == PAIR_APPLY_STATUS.WAIT_VIEW) {//2-3
        reason = "审核通过";
        await updateApply(Number(id), PAIR_APPLY_STATUS.PASS, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else if (status == PAIR_APPLY_STATUS.PASS) {//3-4
        let dbSymbol = await coinType.prototype.findOne({
            where: { symbol: dbApply.coin_symbol },
            raw: true
        });
        if (!dbSymbol) {
            throw ErrorCode.COIN_DATA_NOT_EXIST;
        }
        let dbCurrency = await coinType.prototype.findOne({
            where: { symbol: dbApply.currency_symbol },
            raw: true
        });
        if (!dbCurrency) {
            throw ErrorCode.CURRENT_COIN_DATA_NOT_EXIST;
        }
        //TODO:确定是否查此表 原逻辑 查询ex_pair
        let dbPair = await spotPairs.prototype.findOne({
            where: { symbol: pair },
            raw: true
        });
        if (dbPair) {
            throw ErrorCode.PAIR_EXIST;
        }

        let insertInfo = {
            symbol: pair,
            base: dbApply.coin_symbol,
            quote: dbApply.currency_symbol,
            name: pair,
            price_scale: dbApply.decimal,
            quantity_scale: dbApply.qtyPrecision,
            maker_fee: dbApply.maker_fee,
            taker_fee: dbApply.taker_fee,
            status: 0,
            createdAt: new Date(),
            updatedAt: new Date(),
        }
        //TODO:是否插入此表
        await spotPairs.prototype.create(insertInfo);
        let areaRouterInfo = {
            pair: pair,
            area_id: dbApply.business_area_id,
            weight: dbApply.weight,
            createdAt: new Date(),
            updatedAt: new Date(),
        }
        await exBusinessAreaRouter.prototype.create(areaRouterInfo);
        reason = "交易对创建完成";
        await updateApply(Number(id), PAIR_APPLY_STATUS.CREATE_PAIR, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else if (status == PAIR_APPLY_STATUS.CREATE_PAIR) {//4-5
        //TODO:确定是否查此表 原逻辑 查询ex_pair
        let dbPair = await spotPairs.prototype.findOne({
            where: { symbol: pair },
            raw: true
        });
        if (!dbPair) {
            throw ErrorCode.PAIR_NOT_EXIST;
        }
        let param = {
            "base": dbPair.base, "quote": dbPair.quote, "symbol": dbPair.symbol, "name": dbPair.symbol,
            "price_scale": dbPair.price_scale, "quantity_scale": dbPair.quantity_scale,
            "maker_fee": dbPair.maker_fee, "taker_fee": dbPair.taker_fee
        }
        let optResult = await addPairToCore(param);
        if (!optResult.is_success) {
            throw ErrorCode.ADD_PAIR_TO_CORE_ERR;
        }

        await spotPairs.prototype.update({ status: 1 }, {
            where: {
                id: dbPair.id
            }
        });

        reason = "交易对增加到撮合完成";
        await updateApply(Number(id), PAIR_APPLY_STATUS.ADMIN_ADD_PAIR, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else if (status == PAIR_APPLY_STATUS.ADMIN_ADD_PAIR) {//5-6

        reason = "等待撮合系统重启";
        await updateApply(Number(id), PAIR_APPLY_STATUS.WAIT_ADMIN_RESTART, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else if (status == PAIR_APPLY_STATUS.WAIT_ADMIN_RESTART) {//6-7

        //TODO:确定是否查此表 原逻辑 查询ex_pair
        let dbPair = await spotPairs.prototype.findOne({
            where: { symbol: pair },
            raw: true
        });
        if (!dbPair) {
            throw ErrorCode.PAIR_NOT_EXIST;
        }
        //TODO:新撮合是否需要此操作 初始化
        /*String errStr = spotRpcService.initPair1(dbpair);
        if (errStr != null) {
            return ResponseResult.failure("admin rpc fail: " + errStr);
        }*/
        reason = "发布交易对到撮合完成";
        await updateApply(Number(id), PAIR_APPLY_STATUS.ADMIN_ISSUE_PAIR, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else if (status == PAIR_APPLY_STATUS.ADMIN_ISSUE_PAIR) {//7-8
        //TODO:确定是否查此表 原逻辑 查询ex_pair
        let dbPair = await spotPairs.prototype.findOne({
            where: { symbol: pair },
            raw: true
        });
        if (!dbPair) {
            throw ErrorCode.PAIR_NOT_EXIST;
        }
        let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED);
        let tm_active = dbApply.tm_active;
        if (datetimeUtils.between(tm_active, tm) < 0) {
            throw ErrorCode.ACTIVE_TM_EXPIRE;
        }
        await systemTrigger.prototype.create({
            trigger_symbol: pair,
            trigger_type: 2,
            trigger_action: 2011,
            trigger_time: tm_active,
            status: 0,
            createdAt: new Date(),
            updatedAt: new Date(),
        });
        reason = "交易对激活定时器完成";
        await updateApply(Number(id), PAIR_APPLY_STATUS.TIMER_ACTIVE, currentUser.account, reason, dbApply.coin_symbol, dbApply.currency_symbol);
    }
    else {
        throw ErrorCode.CURRENT_STATUS_NOT_APPLY
    }

    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '上新交易对申请审核', ip, `msg:${reason},dbInfo:${JSON.stringify(dbApply)}`, '交易上下线管理');
    return 'success';
}

async function updateApply(id: number, status: number, checker: string, reason: string, coin_symbol: string, currency_symbol: string) {
    let updateInfo = {
        status: status,
        checker: checker,
        reason: reason ? reason : "",
        updatedAt: new Date()
    }
    await exPairApply.prototype.update(updateInfo, {
        where: {
            id: id
        }
    });
    sendMsg(status, coin_symbol + '_' + currency_symbol);
}

//TODO:发送lark消息
async function sendMsg(status: number, symbol: string) {
    // 1被驳回2申请待审批3审批通过4交易对创建完成5交易对增加到撮合完成6等待撮合系统重启7发布交易对到撮合完成8交易对激活定时器完成9取消
    let content = "";
    if (status == PAIR_APPLY_STATUS.RE_WRITE) {
        content = "申请上交易对,被驳回：" + symbol;
    }
    else if (status == PAIR_APPLY_STATUS.WAIT_VIEW) {
        content = "申请上交易对：" + symbol;
    }
    else if (status == PAIR_APPLY_STATUS.PASS) {
        content = "申请上交易对,审批通过：" + symbol + "，下一步交易对创建";
    }
    else if (status == PAIR_APPLY_STATUS.CREATE_PAIR) {
        content = "申请上交易对,交易对创建完成：" + symbol + "，下一步增加到撮合";
    }
    else if (status == PAIR_APPLY_STATUS.ADMIN_ADD_PAIR) {
        content = "申请上交易对,增加到撮合完成：" + symbol + "，下一步等待撮合系统重启(不需要真的重启撮合)";
    }
    else if (status == PAIR_APPLY_STATUS.WAIT_ADMIN_RESTART) {
        content = "申请上交易对,撮合系统重启完成(不需要真的重启撮合)：" + symbol + "，下一步发布交易对到撮合";
    }
    else if (status == PAIR_APPLY_STATUS.ADMIN_ISSUE_PAIR) {
        content = "申请上交易对,发布交易对到撮合完成：" + symbol + "，下一步激活定时器";
    }
    else if (status == PAIR_APPLY_STATUS.TIMER_ACTIVE) {
        content = "申请上交易对,激活定时器完成：" + symbol + "，流程结束";
    }
    else if (status == PAIR_APPLY_STATUS.CANCEL) {
        content = "申请上交易对,被取消：" + symbol + "，流程结束";
    }
    if (content != null) {
        //TODO:发lark
    }
}

