import * as cronApplyService from "../service/cronApply.service";
import { CronApplyPageVO, CronApplyVO } from "../service/cronApply.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUser, getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 技术部-交易上下线管理-审核上币定时器信息列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: CronApplyPageVO) => {
    let func_name = "cronApply.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await cronApplyService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-删除审核上币定时器
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, cronApplyVO: CronApplyVO) => {
    let func_name = "cronApply.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!cronApplyVO.id) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await cronApplyService.del(cronApplyVO.id, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-增加新币充值定时器
 * @param req
 * @param authConfigVO
 */
export const addDeposit = async (req: any, cronApplyVO: CronApplyVO) => {
    let func_name = "cronApply.control.addDeposit";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!cronApplyVO.trigger_symbol || !cronApplyVO.trigger_time) {
            throw ErrorCode.PARAM_MISS
        }
        let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED * 5);
        if (datetimeUtils.between(cronApplyVO.trigger_time, tm) < 0) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await cronApplyService.addDeposit(cronApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-增加新币提现定时器
 * @param req
 * @param authConfigVO
 */
export const addWithdraw = async (req: any, cronApplyVO: CronApplyVO) => {
    let func_name = "cronApply.control.addWithdraw";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!cronApplyVO.trigger_symbol || !cronApplyVO.trigger_time) {
            throw ErrorCode.PARAM_MISS
        }
        let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED * 5);
        if (datetimeUtils.between(cronApplyVO.trigger_time, tm) < 0) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await cronApplyService.addWithdraw(cronApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



/**
 * 技术部-交易上下线管理-增加交易对激活定时器
 * @param req
 * @param authConfigVO
 */
export const addPairActive = async (req: any, cronApplyVO: CronApplyVO) => {
    let func_name = "cronApply.control.addPairActive";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!cronApplyVO.trigger_symbol || !cronApplyVO.trigger_time || cronApplyVO.is_active == undefined) {
            throw ErrorCode.PARAM_MISS
        }
        let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED * 5);
        if (datetimeUtils.between(cronApplyVO.trigger_time, tm) < 0) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await cronApplyService.addPairActive(cronApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-增加交易对隐藏定时器
 * @param req
 * @param authConfigVO
 */
export const addPairHide = async (req: any, cronApplyVO: CronApplyVO) => {
    let func_name = "cronApply.control.addPairHide";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!cronApplyVO.trigger_symbol || !cronApplyVO.trigger_time || cronApplyVO.is_hide == undefined) {
            throw ErrorCode.PARAM_MISS
        }
        let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED * 5);
        if (datetimeUtils.between(cronApplyVO.trigger_time, tm) < 0) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await cronApplyService.addPairHide(cronApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



