import { aclUserOptLog } from "@madex/ex-ts-dao";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger } = require('@madex/ex-js-public');


export const LogType = {
    DEFAULT: 0,//默认
    LOGIN: 1,//登陆
    ADD: 2,//添加
    UPDATE: 3,//修改
    DEL: 4,//删除
    TOTP: 5,//谷歌
    SAVE: 6,//保存（添加或修改）
}

export const addOptLog = async function (user_id: any, msg: any, type: any, fail_reason?: any, session_id?: any) {
    try {
        if ((!user_id && !session_id) || !msg) {
            throw 'user_id or session_id or msg is null'
        }
        if (!user_id) {
            user_id = await getCurrentUserId(session_id);
        }

        await aclUserOptLog.prototype.create({
            user_id: user_id,
            msg: msg,
            type: type ? type : LogType.DEFAULT,
            createdAt: new Date(),
            updatedAt: new Date(),
            fail_reason: fail_reason ? fail_reason : ''
        })
    }
    catch (e) {
        logger.error('optLogService.addOptLog.error:' + e)
    }
}