const axios = require("axios");

import  configSetting  from "./../../config"
const webadmin_endpoint = configSetting.webadmin_endpoint
let { logger } = require('@madex/ex-js-public');

// { id: 1, symbol: 'BTC' }
export const getCoinFromCore = async(symbol)=> {
    const url = `${webadmin_endpoint}/asset/by_symbol?symbol=${symbol}`
    let { data } = await axios.get(url);
    if (data.error) {
        logger.error("getCoinFromCore",data);
        return null
    }
    return data[0];
}


// {
//     "id": 1,
//      "symbol": 'BTC_USDT',
//     'price-scale': 4,
//     'price-increment': 1,
//     'quantity-scale': 2,
//     'quantity-increment': '0'
// }
export const getPairFromCore = async(symbol,market="spot")=> {
    const url = `${webadmin_endpoint}/pair/by_symbol?symbol=${symbol}&market=${market}`
    let { data } = await axios.get(url);
    if (data.error) {
        logger.error("getPairFromCore",data);
        return null
    }
    return data[0]
}

// getPairFromCore("BTC_USDT").then(console.log)