'use strict';
import { ormDB, coinType, systemTrigger } from "@madex/ex-ts-dao";

let { redisUtilsCommon } = require('@madex/ex-js-common')


const TRIGGER_TYPE_COIN = 1;

const TRIGGER_TYPE_EX_PAIR = 2;


const TRIGGER_STATUS_CANCEL = -1;
const TRIGGER_STATUS_UN_TRIGGER = 0;
const TRIGGER_STATUS_SUCCESS = 1;
const TRIGGER_STATUS_FAIL = 2;

const TRIGGER_ACTION_COIN_TYPE = {
    dis_active: 1010,
    active: 1011,

    unable_deposit: 1020,
    enable_deposit: 1021,

    unable_withdraw: 1030,
    enable_withdraw: 1031,

    unable_transfer: 1040,
    enable_transfer: 1041,
};


const TRIGGER_ACTION_PAIR = {
    dis_active: 2010,
    active: 2011,
    no_hide: 2020,
    hide: 2021,
}

const TRIGGER_ACTION_PAIR_ACTIVE_DIS = 2010;
const TRIGGER_ACTION_PAIR_ACTIVE = 2011;
const TRIGGER_ACTION_PAIR_HIDE_DIS = 2020;
const TRIGGER_ACTION_PAIR_HIDE = 2021;

const KEY_PAIR_LIST = 'active_pairList';

export const getCoinTypeUnTriggers = async function () {
    let unTriggeredList: any = [];
    try {
        unTriggeredList = await systemTrigger.prototype.findAll({
            where: {
                trigger_type: TRIGGER_TYPE_COIN,
                status: TRIGGER_STATUS_UN_TRIGGER,
            },
            raw: true,
        });
    }
    catch (e) {
        console.log('get coin_type unTrigger items fail:', e);
    }
    return unTriggeredList;
}


export const getExPairUnTriggers = async function () {
    let unTriggeredList: any = [];
    try {
        unTriggeredList = await systemTrigger.prototype.findAll({
            where: {
                trigger_type: TRIGGER_TYPE_EX_PAIR,
                status: TRIGGER_STATUS_UN_TRIGGER,
            },
            raw: true,
        });
    }
    catch (e) {
        console.log('get ex_pair unTrigger items fail:', e);
    }
    return unTriggeredList;

}

export const doExPairTrigger = async function (trigId: any, ex_pair: any, action: any) {
    let rtn:any = false;
    try {
        //TODO:目前交易对 没有激活  隐藏相关字段了 之后有的话  再补充
        //let pair = await exPair.prototype.findOne({ where: { pair: ex_pair }, raw: true });
        let pair = null;
        if (!pair) {
            //交易对不存在，标记触发失败
            await systemTrigger.prototype.update({ status: TRIGGER_STATUS_FAIL }, { where: { id: trigId, status: 0 } });
            rtn = false;
        }
        else {

            let target_value = {};
            switch (action) {
                case TRIGGER_ACTION_PAIR.dis_active:
                    target_value = { is_active: 0 };
                    break;
                case TRIGGER_ACTION_PAIR.active:
                    target_value = { is_active: 1 };
                    break;
                case TRIGGER_ACTION_PAIR.no_hide:
                    target_value = { is_hide: 0 };
                    break;
                case TRIGGER_ACTION_PAIR.hide:
                    target_value = { is_hide: 1 };
                    break
                default:
                    await systemTrigger.prototype.update({ status: TRIGGER_STATUS_FAIL }, { where: { id: trigId, status: 0 } });
                    rtn = false;
                    return rtn;
            }

            //操作ex_pair 和 system_trigger
            let t;
            try {
                console.log('start transaction');
                t = await ormDB.transaction();
                //TODO: 目前交易对 没有激活  隐藏相关字段了 之后有的话  再补充
                //await exPair.prototype.update(target_value, { where: { pair: ex_pair }, transaction: t });
                await systemTrigger.prototype.update({ status: TRIGGER_STATUS_SUCCESS }, { where: { id: trigId, status: 0 }, transaction: t });
                await t.commit();
                rtn = true;
            }
            catch (e) {
                console.log('transaction fail', e);
                if (t) {
                    t.rollback();
                }
                rtn = false;
            }
        }

    }
    catch (e) {
        console.error('doExPairTrigger:', e);
    }
    return rtn;
}


export const doCoinTypeTrigger = async function (trigId: any, coinSymbol: any, action: any) {

    let rtn = false;
    try {

        let symbol = await coinType.prototype.findOne({ where: { symbol: coinSymbol }, raw: true });
        if (!symbol) {
            //币种不存在
            await systemTrigger.prototype.update({ status: TRIGGER_STATUS_FAIL }, { where: { id: trigId, status: 0 } });
            rtn = false;
        }
        else {
            let target_value = {};
            switch (action) {
                case TRIGGER_ACTION_COIN_TYPE.dis_active:
                    target_value = { is_active: 0 };
                    break;
                case TRIGGER_ACTION_COIN_TYPE.active:
                    target_value = { is_active: 1 };
                    break;
                case TRIGGER_ACTION_COIN_TYPE.unable_deposit:
                    target_value = { enable_deposit: 0 };
                    break;
                case TRIGGER_ACTION_COIN_TYPE.enable_deposit:
                    target_value = { enable_deposit: 1 };
                    break;

                case TRIGGER_ACTION_COIN_TYPE.unable_withdraw:
                    target_value = { enable_withdraw: 0 };
                    break;
                case TRIGGER_ACTION_COIN_TYPE.enable_withdraw:
                    target_value = { enable_withdraw: 1 };
                    break;

                case TRIGGER_ACTION_COIN_TYPE.unable_transfer:
                    target_value = { enable_transfer: 0 };
                    break;
                case TRIGGER_ACTION_COIN_TYPE.enable_transfer:
                    target_value = { enable_transfer: 1 };
                    break;
            }
            //操作ex_pair 和 system_trigger
            let t;
            try {
                console.log('start transaction');
                t = await ormDB.transaction();
                await coinType.prototype.update(target_value, { where: { symbol: coinSymbol }, transaction: t });
                await systemTrigger.prototype.update({ status: TRIGGER_STATUS_SUCCESS }, { where: { id: trigId, status: 0 }, transaction: t });
                await t.commit();
                rtn = true;
            }
            catch (e) {
                console.log('transaction fail', e);
                if (t) {
                    t.rollback();
                }
                rtn = false;
            }
        }
    }
    catch (e) {
        console.error('doCoinTypeTrigger fail:', e);
    }
    return rtn;
}

/**
 * 更新redis active_pairList
 */
export const updateRedisPairs = async function () {
    console.log('updateRedisPairs');
    try {
        //TODO:没有了
        //let list = await exPair.prototype.findAll({ where: { is_active: 1 } });
        // redisUtilsCommon.writeSync(KEY_PAIR_LIST, JSON.stringify(list));
    }
    catch (e) {
        console.error(e);
    }
}
