import Config from "../../config";

let { redisUtilsCommon: RedisUtils } = require('@madex/ex-js-common')
let { logger, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public')
import { ErrorCode } from "../constant/errorCode";
import * as aclRoleAuthService from "../functional/mvc/service/aclRoleAuth.service";
import { AclUserInfoConst } from "../constant/aclUserConstant";

const aclPass = [
    'user/getInfo',
    'acl/auth/tree',
    'acl/role/getAll',
    'user/bind/totp/ask',
    'user/bind/totp/confirm',
    'user/updatePwd',
    'acl/user/add'
]
export const getCookie = async function (sessionId: string) {
    let func_name = 'reqUtils.getCookie';
    try {
        let cookieData = await RedisUtils.getSync(sessionId);
        if (!cookieData || !cookieData.userId) {
            throw ErrorCode.NOT_LOGIN;
        }
        return cookieData;
    }
    catch (e) {
        logger.error(`${func_name}.error:` + e);
        throw e;
    }
}

export const checkCookie = async (cookies: any, isAdminExclude: any, path: any, req: any) => {

    ApiAssert.isNotEmpty(ErrorCode.NOT_LOGIN, cookies);
    ApiAssert.isNotEmpty(ErrorCode.NOT_LOGIN, cookies.session_id);


    let sessionId = cookies.session_id;
    let cookieData = await RedisUtils.getSync(sessionId);
    ApiAssert.isNotEmpty(ErrorCode.NOT_LOGIN, cookieData);
    if (!cookieData.authSet && cookieData.userId) {
        // 自动注入acl于缓存
        let { roleSet, authSet } = await aclRoleAuthService.getUserAcl(cookieData.userId);
        cookieData.roleSet = roleSet;
        cookieData.authSet = authSet;
        await RedisUtils.writeSync(sessionId, cookieData, Config.LOGIN_EXPIRED);
    }
    //管理员需要强制绑定谷歌
    if (!cookieData.totp_encrypt && isAdminExclude) {
        return cookieData
    }
    ApiAssert.isTrue(ErrorCode.NEED_INPUT_GOOGLE_CODE, Number(cookieData.needConfirm) === 0)
    if (cookieData.allow_ips) {
        let ips = cookieData.allow_ips.split(",");
        if (!ips.includes("*.*.*.*") && !ips.includes("0.0.0.0") && !ips.includes(req.ip)) {
            throw ErrorCode.IP_ADDR_LIMIT
        }
    }
    await aclCheck(cookieData, path, req)

    return cookieData;

}

async function aclCheck(cookieData: any, path: any, req: any) {

    path = toHump(path); //先转驼峰
    if (aclPass.includes(path)) {
        return;
    }

    if (!cookieData.authSet.includes(path)) {
        throw ErrorCode.NO_PERMISSION;
    }
}

export const parsePath = function (url: any) {
    if (!url) return url;
    if (!url.includes(Config.BASE_URL)) return url;
    let r = url.replace(Config.BASE_URL, "");
    r = r.split("?")[0];
    return r;
}

function toHump(name: any) {
    if (name.includes("_")) {
        return name.replace(/\_(\w)/g, function (all, letter) {
            return letter.toUpperCase();
        });
    }
    return name;
}