import { ormDB, airdropSetting,airdropPrize } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger, datetimeUtils } = require('@madex/ex-js-public');


export interface AirdropVO {
    id?: number;
    name?: string | any;
    icon?: string | any;
    symbol?: string | any;
    desc?: string | any;
    website?: string | any;
    white_paper?: string | any;
    total?: number;
    hard_limit?: number;
    lock_type?: number;
    lock_symbol?: string | any;
    lock_name?: string | any;
    lock_icon?: string | any;
    lock_time?: number;
    weight?: string | any;
    rule?: string | any;
    start_time?: Date | any;
    end_time?: Date | any;
    status?: number;
    createdAt?: Date | any;
    updatedAt?: Date | any;
}

export interface AirdropPageVO extends AirdropVO {
    user_id?: number,
    search? :string | any;
    page?: number;
    size?: number;
}

export async function list(airdropPageVO: AirdropPageVO) {
    let where = {}
    let search = airdropPageVO.search;
    if (search) {
        where = {
            [ormDB.Op.or]: {
                symbol: { [ormDB.Op.like]: `${search}%` },
                name: { [ormDB.Op.like]: `%${search}%` },
            }
        }
    }

    let resList = await airdropSetting.prototype.findAndCount({
        where: where,
        limit: airdropPageVO.size,
        offset: (Number(airdropPageVO.page) - 1) * Number(airdropPageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export async function prizeList(airdropPageVO: AirdropPageVO) {
    let where = {}
    let user_id = airdropPageVO.user_id;
    if (user_id) {
        where = {
            user_id: Number(airdropPageVO.user_id),
        }
    }

    let resList = await airdropPrize.prototype.findAndCount({
        where: where,
        limit: airdropPageVO.size,
        offset: (Number(airdropPageVO.page) - 1) * Number(airdropPageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export async function save(airdropVO: AirdropVO, currentUserId: any, ip: any) {

    if (!airdropVO.id) {
        airdropVO.status = 0;
        await airdropSetting.prototype.create(airdropVO);

    }else {
        await airdropSetting.prototype.update(airdropVO,{
            where:{
                id:Number(airdropVO.id)
            }
        })
    }

    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增或修改空投活动', ip, JSON.stringify(airdropVO), '空投活动');
    return 'success'
}







