import { ormDB, feeRateSpotLog, feeRateContractLog, commonUserFeeSetting, feeRateBaseCoinContractLog } from "@madex/ex-ts-dao";
import { FEE_STATUS } from "../../src/constant/marketMakerConst";

const logger = require('@madex/ex-js-public').logger;

import * as RobotUtil from "../../src/utils/robotUtils";

let OP = ormDB.Op;

let fee_rate_spot_log = feeRateSpotLog.prototype;
let fee_rate_contract_log = feeRateContractLog.prototype;
let fee_rate_base_coin_contract_log = feeRateBaseCoinContractLog.prototype;
let common_user_fee_setting = commonUserFeeSetting.prototype;

/**
 * 根据id获取币币手续费设置纪录。
 * @param id
 * @returns {Promise<Model>}
 */
export const spotFeeStatusCheck = async function (id) {
    return await fee_rate_spot_log.findOne({
        attributes: ['id', 'is_check'],
        where: {
            id: id,
        },
        raw: true,
    });
};

/**
 * 根据id获取合约手续费设置纪录。
 * @param id
 * @returns {Promise<Model>}
 */
export const contractFeeStatusCheck = async function (id) {
    return await fee_rate_contract_log.findOne({
        attributes: ['id', 'is_check'],
        where: {
            id: id,
        },
        raw: true,
    });
};

export const baseCoinContractFeeStatusCheck = async function (id) {
    return await fee_rate_base_coin_contract_log.findOne({
        attributes: ['id', 'is_check'],
        where: {
            id: id,
        },
        raw: true,
    });
};

/****************************************** 普通用户费率设置状态更新相关操作。 **********************************************/

/**
 * 获取已提交且到开始时间的的记录。
 *
 * @returns {Promise<Model>}
 */
export const findUserFeeDataNeed2Active = async function () {
    return await common_user_fee_setting.findAll({
        where: {
            begin_time: { [OP.lte]: new Date() },
            status: FEE_STATUS.STATUS_FEE_SETTING_SUBMIT,
        },
        raw: true,
    });
};

/**
 * 获取已生效且到过期时间的。
 *
 * @returns {Promise<Model>}
 */
export const findUserFeeDataNeed2Expire = async function () {
    return await common_user_fee_setting.findAll({
        where: {
            expire_time: { [OP.lt]: new Date() },
            status: FEE_STATUS.STATUS_FEE_SETTING_EFFECTED,
        },
        raw: true,
    });
};

/**
 * 更新手续费设置纪录的状态。
 * @returns {Promise<void>}
 */
export const userFeeSettingStatusUpdate = async function (id, status) {
    try {
        let toUpdate = {
            status: status,
            update_time: new Date()
        };
        let condition = {
            id: id,
        };
        await common_user_fee_setting.update(toUpdate, {
            where: condition
        });
        logger.warn("task.fee.setting.status.update.model.userFeeSettingStatusUpdate data update success.");
    }
    catch (e) {
        let msg = `task.fee.setting.status.update.model.userFeeSettingStatusUpdate data update fail! id: ${id}, status: ${status}`;
        logger.error(msg);
        RobotUtil.sendRobotMessage(RobotUtil.ROBOT_KEYS.COMMON_KEY, msg);
    }

};
