import { financeAccountCategory, ormDB, financeAccount } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface FinanceAccountCategoryVO {
    id?: number;

    name?: string | any;

    remark?: string | any;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface FinanceAccountCategoryPageVO extends FinanceAccountCategoryVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: FinanceAccountCategoryPageVO) {
    let where = {};

    let resList = await financeAccountCategory.prototype.findAll({
        where: where,
        order: [["id", "asc"]],
        raw: true
    });
    return resList;
}


export async function add(financeAccountCategoryVO: FinanceAccountCategoryVO, currentUserId: any, ip: any) {

    financeAccountCategoryVO.createdAt = new Date();
    financeAccountCategoryVO.updatedAt = new Date();


    await financeAccountCategory.prototype.create(financeAccountCategoryVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增账户分类', ip, JSON.stringify(financeAccountCategoryVO), '金融部-其他管理');
    return 'success';
}


export async function update(financeAccountCategoryVO: FinanceAccountCategoryVO, currentUserId: any, ip: any) {
    let exist = await financeAccountCategory.prototype.findOne({
        where: {
            id: financeAccountCategoryVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }


    financeAccountCategoryVO.updatedAt = new Date();
    await financeAccountCategory.prototype.update(financeAccountCategoryVO, {
        where: {
            id: Number(financeAccountCategoryVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改账户分类', ip, JSON.stringify(financeAccountCategoryVO), '金融部-其他管理');

    return 'success';
}

export async function del(id: number, currentUserId: any, ip: string | undefined) {
    let exist = await financeAccountCategory.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }
    //分类下有账户 不可以删除
    let dbAccount = await financeAccount.prototype.findOne({
        where: {
            category_id: id
        },
        raw: true
    });
    if (dbAccount) {
        throw ErrorCode.CATEGORY_HAVE_ACCOUNT;
    }

    await financeAccountCategory.prototype.destroy({
        where: {
            id: id
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除账户分类', ip, `id:${id}`, '金融部-其他管理');

    return 'success';
}



