import { ormDB, appVersion, arbitrageOrmDB, appFeatureManage, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface AppFeatureVO {
    id?: number;

    feature?: string | any;

    feature_type?: number;

    icon_url?: string;

    tag?: string;

    display_device?: string;//0:全部安卓和ios; 1: 安卓; 2: ios; 3: web; -1: 全部;

    link_type?: number,

    link_ios?: string;

    link_android?: string;

    link_web?: string;

    weight?: number;

    is_hidden?: number;

    is_fixed?: number;

    is_default?: number;

    version?: string;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface AppFeaturePageVO extends AppFeatureVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: AppFeaturePageVO) {

    let where = {};
    if (pageVO.display_device || pageVO.display_device === "0") {
        where['display_device'] = pageVO.display_device
    }

    if (pageVO.feature) {
        where['feature'] = { [arbitrageOrmDB.Op.like]: `%${pageVO.feature}%` }
    }

    if (pageVO.is_hidden) {
        where['is_hidden'] = pageVO.is_hidden
    }

    if (pageVO.link_type) {
        where['link_type'] = pageVO.link_type
    }

    if (pageVO.is_default) {
        where['is_default'] = pageVO.is_default
    }


    let resList = await appFeatureManage.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["updatedAt", "desc"]],
        raw: true
    });
    return resList;
}


export async function add(appFeatureVO: AppFeatureVO, currentUserId: any, ip: string | undefined) {

    appFeatureVO.createdAt = new Date();
    appFeatureVO.updatedAt = new Date();

    await appFeatureManage.prototype.create(appFeatureVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增App首页入口', ip, JSON.stringify(appFeatureVO), 'App首页入口管理');
    return 'success';
}


export async function update(appFeatureVO: AppFeatureVO, currentUserId: any, ip: string | undefined) {
    let exist = await appFeatureManage.prototype.findOne({
        where: {
            id: appFeatureVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }


    appFeatureVO.updatedAt = new Date();
    await appFeatureManage.prototype.update(appFeatureVO, {
        where: {
            id: Number(appFeatureVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改App入口信息', ip, JSON.stringify(appFeatureVO), 'App首页入口管理');

    return 'success';
}

export async function del(id: number, currentUserId: any, ip: string | undefined) {
    let exist = await appFeatureManage.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    await appFeatureManage.prototype.destroy({
        where: {
            id: id
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除App入口信息', ip, `id:${id}`, 'App首页入口管理');

    return 'success';
}



