
let {
    debug,
    logger
} = require('@madex/ex-js-public');
const {
    larkRobotUtils: LarkRobotUtils,
} = require("@madex/ex-js-common")

let config = require('../../config');


debug = config.env === "development";

let COMMON_KEY = "9e06e260-6c2f-49d4-98b4-e08ef096f6f5";
//测试
if (debug) {
    COMMON_KEY = "9e06e260-6c2f-49d4-98b4-e08ef096f6f5";
}
export const ROBOT_KEYS = {
    COMMON_KEY: COMMON_KEY
}
/**
 *
 * @param url 机器人链接 （必填）
 * @param content 发送内容（必填）
 * @param _func_name_ 报错方法（可选）
 */
export const sendRobotMessage = async function (url: string, content: any, _func_name_?: string) {

    if (typeof content != 'string') {
        if (content && content.sql) {
            content = `backend._func_name_ ${_func_name_}, ${content.sql}`;
        }
        else if (content && content.message) {
            content = `backend._func_name_ ${_func_name_}, ${content.message}`;
        }
        else {
            content = `backend._func_name_ ${_func_name_}, ${JSON.stringify(content)}`;
        }
    }
    else {
        content = `backend._func_name_ ${_func_name_}, ${content}`;
    }

    if (debug) {
        content = `backend.测试.${content}`;
        await doSend(COMMON_KEY, content);
    }
    else {
        await doSend(url, content);
    }

}

async function doSend(url: string, content: any) {
    logger.info('robot message', url, content);
    await LarkRobotUtils.sendTextSimple(url, content).catch()
}
