import * as mUserSubscribeService from "../service/mUserSubscribe.service";
import { QueryVO } from "../service/mUserSubscribe.service";
import * as mUserMailLogService from "../service/mUserMailLog.service";
import { UserMailLogVO } from "../service/mUserMailLog.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { IS_ACTIVE, IS_ACTIVE_ARR, LINK_TYPE_ARR } from "../../../constant/usefulLinkConst";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 订阅列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserSubscribe.control.list";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        let res = await mUserSubscribeService.list(queryVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除订阅
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserSubscribe.control.delete";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, queryVO.id);
        let res = await mUserSubscribeService.del(Number(queryVO.id), currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 订阅统计
 * @param req
 * @param authConfigVO
 */
export const count = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserSubscribe.control.count";
    try {
        let res = await mUserSubscribeService.count();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 邮件发送历史
 * @param req
 * @param infoVO
 */
export const history = async (req: any, userMailLogVO: UserMailLogVO) => {
    let func_name = "mUserSubscribe.control.history";
    try {
        userMailLogVO.page = Optional.opt(userMailLogVO, 'page', 1);
        userMailLogVO.size = Optional.opt(userMailLogVO, 'size', 20);
        let res = await mUserMailLogService.history(userMailLogVO.page, userMailLogVO.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 邮件详情
 * @param req
 * @param infoVO
 */
export const mailDetail = async (req: any, userMailLogVO: UserMailLogVO) => {
    let func_name = "mUserSubscribe.control.mailDetail";
    try {
        if (!userMailLogVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserMailLogService.mailDetail(userMailLogVO.id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 邮件发送
 * @param req
 * @param userMailLogVO
 */
export const mailSend = async (req: any, userMailLogVO: UserMailLogVO) => {
    let func_name = "mUserSubscribe.control.mailSend";
    try {
        if (!userMailLogVO.subject || !userMailLogVO.content) {
            throw ErrorCode.PARAM_MISS
        }

        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let subjectBuf = Buffer.from(String(userMailLogVO.subject), 'base64');
        let contentBuf = Buffer.from(String(userMailLogVO.content), 'base64');
        userMailLogVO.subject = subjectBuf.toString('utf8');
        userMailLogVO.content = contentBuf.toString('utf8');

        let res = await mUserMailLogService.mailSend(userMailLogVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 群发邮件
 * @param req
 * @param userMailLogVO
 */
export const maiSendGroup = async (req: any, userMailLogVO: UserMailLogVO) => {
    let func_name = "mUserSubscribe.control.maiSendGroup";
    try {
        if (!userMailLogVO.subject || !userMailLogVO.content || !userMailLogVO.uidStr) {
            throw ErrorCode.PARAM_MISS
        }
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);

        let subjectBuf = Buffer.from(String(userMailLogVO.subject), 'base64');
        let contentBuf = Buffer.from(String(userMailLogVO.content), 'base64');
        userMailLogVO.subject = subjectBuf.toString('utf8');
        userMailLogVO.content = contentBuf.toString('utf8');
        let uids = userMailLogVO.uidStr.split(",");
        if (uids.length > 1000) {
            throw ErrorCode.UID_TOO_MUCH;
        }
        for (let uid of uids) {
            if (!uid) {
                throw ErrorCode.UID_ILLEGALITY;
            }
        }

        let res = await mUserMailLogService.maiSendGroup(userMailLogVO.subject, userMailLogVO.content, currentUserId, ip, uids);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};