/**
 * 原文件:b024 - task_fee_rate_spot_log.js
 */
import { ormDB, userInfoSon, feeRateSpotLog, spotPairs } from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";
import { changeUserSpotFee, isWhiteListUser } from "../model/task.fee.rate.log.model";

let { redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');
const schedule = require('node-schedule');
const logger = require('@madex/ex-js-public').logger;
let user_info_son = userInfoSon.prototype;
let fee_rate_spot_log = feeRateSpotLog.prototype;
let feeRateCheckStatus = FEE_RATE_LOG_STATUS;
let Op = ormDB.Op;


const oneHour = 1000 * 60 * 60;
const oneDay = oneHour * 24;
const oneMonth = oneDay * 30;


let inJob = false;
let limit = 3000;


let setFeeRateJob = schedule.scheduleJob('*/30 * * * * *', function () {
    if (inJob) {
        return;
    }
    inJob = true;
    doJob().catch(err => {
        logger.warn('setFeeRateJob', err);
    }).then(() => {
        inJob = false;
    });
});

let setDefaultRun = false;
let setExpiredDefaultJob = schedule.scheduleJob('*/5 * * * *', function () {
    logger.info(' spot setExpiredDefaultJob run ', new Date().toISOString());
    if (setDefaultRun) {
        return;
    }
    setDefaultRun = true;
    setExpiredDefault().then(res => {
        setDefaultRun = false;
    }).catch(err => {
        setDefaultRun = false;
        logger.warn('spot  setFeeRateJob', err);
    })
});

let doJob = async function () {
    let ctm = new Date();
    let dblogs = await fee_rate_spot_log.findAll({
        where: {
            is_check: 0,
            beginAt: { [Op.lte]: ctm },
            expireAt: { [Op.gte]: ctm },
            taker_fee: { [Op.gte]: 0 },
        },
        limit: limit,
        raw: true,
    });
    for (let i = 0; i < dblogs.length; i++) {

        if (Number(dblogs[i].maker_fee) < 0 && (Math.abs(Number(dblogs[i].maker_fee)) > Math.abs(Number(dblogs[i].taker_fee)))) {
            continue;
        }

        await changeOneFee(dblogs[i]);
    }
    await removeOldLog();
};

let changeOneFee = async function (dblog) {
    let transaction;
    return changeUserSpotFee(
        dblog.user_id, dblog.pair, dblog.fee_model, dblog.maker_fee, dblog.taker_fee, dblog.id
    ).then(async res => {
        if (!res) {
            throw 'changeUserFee fail';
        }
        let dbsons = await user_info_son.findAll({
            attributes: ['user_id'],
            where: {
                father_id: dblog.user_id,
            },
            raw: true,
        });

        let son_fee_rate: any = [];
        for (let i = 0; i < dbsons.length; i++) {
            let son = dbsons[i];
            son_fee_rate.push({
                user_id: son.user_id,
                pair: dblog.pair,
                fee_model: dblog.fee_model,
                maker_fee: dblog.maker_fee,
                taker_fee: dblog.taker_fee,
                beginAt: new Date(),
                expireAt: dblog.expireAt,
                is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
                comment: '继承父账户费率',
            });
        }
        await storeUserSpotFeeRedis(dblog.user_id, dblog.pair, dblog.taker_fee, dblog.maker_fee);
        transaction = await ormDB.transaction();
        await fee_rate_spot_log.update({ // 将当前生效中的值置为过期
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
        }, {
            where: {
                user_id: dblog.user_id,
                pair: dblog.pair,
                is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE,
            },
            transaction: transaction,
        });
        await fee_rate_spot_log.update({
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE,
        }, {
            where: {
                id: dblog.id,
                user_id: dblog.user_id,
                pair: dblog.pair,
                is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            },
            transaction: transaction,
        });
        if (son_fee_rate.length > 0) {
            await fee_rate_spot_log.bulkCreate(son_fee_rate, {
                transaction: transaction,
            });
        }

        await transaction.commit();
        transaction = null;
    }).catch(async err => {
        if (transaction) {
            await transaction.rollback();
            transaction = null;
        }

        if (err == 3000) {
            await fee_rate_spot_log.update({
                is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
            }, {
                where: {
                    id: dblog.id,
                    user_id: dblog.user_id,
                    pair: dblog.pair,
                    is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
                },
            });
        }
        logger.warn('setFeeRateJob.changeOneFee', dblog, err);
    });
};

let removeOldLog = async function () {
    let ctm = Date.now();
    let etm = new Date(ctm - 1000 * 60 * 60 * 24 * 31);
    await fee_rate_spot_log.destroy({
        where: {
            is_check: {
                [Op.in]: [
                    feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
                    feeRateCheckStatus.CHECK_STATUS_DELETED,
                ]
            },
            updatedAt: { [Op.lt]: etm },
        }
    });
};


async function storeUserSpotFeeRedis(user_id, pair, taker_fee, maker_fee) {
    let redisKey = 'user_spot_fee_rate_' + user_id;
    let res = await RedisClient.getSync(redisKey);
    if (!res) {
        res = {};
    }
    res[pair] = {
        taker: taker_fee,
        maker: maker_fee
    }
    await RedisClient.writeSync(redisKey, JSON.stringify(res));
}

// 过期费率处理
async function setExpiredDefault() {
    let comment = '费率到期系统自动调整为基础费率';
    let ctm = new Date(Date.now() - oneDay); // 已经过期一段时间;
    let expirdFees = await fee_rate_spot_log.findAll({
        attributes: ['user_id', 'pair', 'fee_model', 'maker_fee', 'taker_fee'],
        where: {
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE, // 正在生效中的
            expireAt: { [Op.lte]: ctm },
        },
        limit: 500, // 后边处理插入时可以单次插入
        raw: true,
    });
    if (expirdFees.length == 0) return;
    let expiredUsers: any = [];
    for (let i = 0; i < expirdFees.length; i++) {
        expiredUsers.push(expirdFees[i].user_id);
    }

    let uncheckCounts = await fee_rate_spot_log.findAll({
        attributes: [[ormDB.literal('count(1)'), 'amount'], 'user_id'],
        where: {
            user_id: expiredUsers,
            is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            beginAt: { [Op.lte]: new Date() },
            comment,
        },
        raw: true,
        group: ['user_id'],
    });
    let unCheckCountObj = {};
    for (let i = 0; i < uncheckCounts.length; i++) {
        let { user_id, amount } = uncheckCounts[i];
        unCheckCountObj[user_id] = amount;
    }

    let defaultPairFee = await spotPairs.prototype.findAll({
        attributes: ['maker_fee', 'taker_fee', 'symbol'],
        where: {
            status: 2
        },
        raw: true,
    });
    let defaultFeeObj = {}, init_maker_rate = 0.001, init_taker_rate = 0.002;  // 初始用户费率
    let activePairs: any = ['all'];
    for (let i = 0; i < defaultPairFee.length; i++) {
        let { symbol } = defaultPairFee[i];
        activePairs.push(symbol);
        defaultFeeObj[symbol] = defaultPairFee[i];
    }

    let newFeeArr: any = [];
    let beginAt = new Date();
    let expiredPairs: any = [];
    for (let i = 0; i < expirdFees.length; i++) {
        let { pair, fee_model, user_id } = expirdFees[i];

        if (await isWhiteListUser(user_id)) {
            continue;
        }
        if (!activePairs.includes(pair)) {
            expiredPairs.push(pair);
            continue;
        }
        if (unCheckCountObj[user_id] > 0) { // 已经存在
            continue;
        }
        newFeeArr.push({
            user_id,
            pair: pair,
            fee_model,
            maker_fee: defaultFeeObj[pair] ? defaultFeeObj[pair].maker_fee : init_maker_rate,
            taker_fee: defaultFeeObj[pair] ? defaultFeeObj[pair].taker_fee : init_taker_rate,
            beginAt: beginAt,
            expireAt: new Date(beginAt.getTime() + oneMonth),
            is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            comment: comment,
        });
    }
    if (expiredPairs.length > 0) { // 下线交易对处理
        await fee_rate_spot_log.update({
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
        }, {
            where: {
                pair: expiredPairs,
            }
        })
    }
    if (newFeeArr.length > 0) {
        let trans: any;
        try {
            trans = await ormDB.transaction();
            await fee_rate_spot_log.update({
                is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
            }, {
                where: {
                    user_id: expiredUsers,
                    is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE, // 正在生效中的
                    expireAt: { [Op.lte]: ctm },
                },
                transaction: trans,
            });
            await fee_rate_spot_log.bulkCreate(newFeeArr, {
                transaction: trans,
            });
            await trans.commit();
            trans = null;
        }
        catch (error) {
            if (trans) {
                trans.rollback();
            }
        }
    }
}

//setFeeRateJob.invoke();
//setExpiredDefaultJob.invoke();