'use strict';
import * as ReqUtils from "../utils/req-utils";
import * as pairApplyCtrl from "../functional/mvc/control/pairApply.control";

const {
    Res3Utils,
    logger: Logger,
} = require("@madex/ex-js-public");


let cmdWhiteList = {
    //技术部-其他管理-国际化管理
    'i18n/info/list': 1,
    'i18n/info/add': 1,
    'i18n/info/update': 1,
    'i18n/info/del': 1,
    'i18n/info/log/list': 1,
    'i18n/info/log/revert': 1,
    //金融部-交易管理-交易对配置
    'spotPair/save': 1,
    'spotPair/update': 1,
    'spotPair/list': 1,
    'spotPair/pushToCoreSystem': 1,
    'spotPair/getAllSubmitSuccess': 1,
    //运营部-其他管理-币种管理
    'coinType/save': 1,
    'coinType/update': 1,
    'coinType/list': 1,
    'coinType/pushToCoreSystem': 1,
    'coinType/getAllSubmitSuccess': 1,

    //权限管理 - 我的权限
    'user/getInfo': 1,
    'user/getInfoByUserId': 1,
    'user/getInfoDetailByUserId': 1,
    //权限管理 - 组织结构
    'department/pageList': 1,
    'department/allList': 1,
    'department/getDepartmentTree': 1,
    'department/add': 1,
    'department/update': 1,
    'department/del': 1,
    'department/userList/dpIdsOrAccount': 1,
    'position/allList': 1,
    //权限管理 - 后台角色管理
    'acl/role/list': 1,
    'acl/role/getByUser': 1,
    'acl/role/getAll': 1,
    'acl/role/save': 1,
    'acl/role/del': 1,
    //'acl/changeRoleAuth': 1,
    'acl/auth/list': 1,
    'acl/auth/tree': 1,
    'acl/auth/getByUser': 1,
    'acl/auth/getByRole': 1,
    'acl/auth/save': 1,
    'acl/auth/del': 1,
    //权限管理 - 后台用户管理
    'acl/user/add': 1,
    'acl/user/list': 1,
    'acl/user/update': 1,
    'acl/user/checkTotpCode': 1,
    'acl/changeUserRole': 1,
    'acl/user/opt/log/list': 1,

    'user/login': 1,
    'user/logout': 1,
    'user/login/confirm': 1,
    'user/bind/totp/ask': 1,
    'user/bind/totp/confirm': 1,
    'user/auth/reset/totp': 1,

    //运营部-其他管理-热门交易对搜索
    'hot/pair/config/list': 1,
    'hot/pair/config/add': 1,
    'hot/pair/config/update': 1,
    'hot/pair/config/del': 1,
    //运营部-其他管理-消息通知
    'notice/list': 1,
    'notice/add': 1,
    'notice/update': 1,
    //客服部- 用户管理
    'mUser/manage/userList': 1,
    'mUser/manage/oneUserDetail': 1,
    'mUser/manage/updateUserEmail': 1,
    'mUser/manage/lockAccount': 1,
    'mUser/manage/unlockAccount': 1,
    'mUser/manage/clearLoginLimit': 1,
    'mUser/manage/clear24WithdrawLimit': 1,
    'mUser/manage/kyc/list': 1,
    'mUser/manage/kyc/oneDetail': 1,
    'mUser/manage/kyc/audit': 1,
    'mUser/manage/kyc/auditors': 1,
    'mUser/manage/walletAsset/detail': 1,
    'mUser/manage/asset/distribution': 1,
    'mUser/manage/tradeAsset/detail': 1,
    'mUser/manage/order/pending/list': 1,
    'mUser/manage/order/history/list': 1,
    'mUser/manage/order/detail/list': 1,
    //运营部-现货-资源位管理
    'link/useful/list': 1,
    'link/useful/add': 1,
    'link/useful/delete': 1,
    'link/useful/update': 1,
    'link/useful/detail': 1,
    //运营部-其他管理-邮件订阅
    'mUser/subscribe/list': 1,
    'mUser/subscribe/delete': 1,
    'mUser/subscribe/count': 1,
    'mUser/subscribe/mail/history': 1,
    'mUser/subscribe/mail/send': 1,
    'mUser/subscribe/mail/detail': 1,
    'mUser/subscribe/mail/send/group': 1,
    //运营部-现货-VIP管理(普通用户手续费、市商手续费)
    'mUser/fee/setting/list': 1,
    'mUser/fee/setting/add': 1,
    'mUser/fee/setting/update': 1,
    'mUser/fee/setting/delete': 1,
    //'mUser/fee/setting/submit': 1,
    'mUser/fee/vip/level/list': 1,
    //技术部-App管理-App版本管理
    'tech/app/version/list': 1,
    'tech/app/version/add': 1,
    'tech/app/version/update': 1,
    //技术部-App管理-App首页入口管理
    'tech/app/feature/list': 1,
    'tech/app/feature/add': 1,
    'tech/app/feature/update': 1,
    'tech/app/feature/del': 1,
    //技术部-App管理-App审核管理
    'tech/app/apply/version/list': 1,
    'tech/app/apply/version/modify': 1,
    //技术部-App管理-App动态域名
    'tech/app/dynamic/domain/get': 1,
    'tech/app/dynamic/domain/update': 1,
    //技术部-App管理-App特定机型配置
    'tech/app/special/model/get': 1,
    'tech/app/special/model/update': 1,
    //技术部-其他管理-触发配置管理
    'tech/other/system/trigger/list': 1,
    'tech/other/system/trigger/add': 1,
    'tech/other/system/trigger/update': 1,
    'tech/other/system/trigger/del': 1,
    //技术部-其他管理-API限速管理
    'tech/other/apikey/strict/list': 1,
    'tech/other/apikey/strict/add': 1,
    'tech/other/apikey/strict/update': 1,
    'tech/other/apikey/strict/del': 1,
    //金融部-交易管理-合约代码配置
    'finance/trade/contract/pair/set': 1,
    'finance/trade/contract/pair/update': 1,
    'finance/trade/contract/pair/query': 1,
    //金融部-其他管理-现货做市参数配置
    'fiance/other/spot/market/maker/set': 1,
    'fiance/other/spot/market/maker/list': 1,
    'fiance/other/spot/market/maker/param/get': 1,
    'fiance/other/spot/market/maker/param/set': 1,
    //金融部-其他管理-合约做市参数配置
    'fiance/other/contract/market/maker/set': 1,
    'fiance/other/contract/market/maker/list': 1,
    'fiance/other/contract/market/maker/param/get': 1,
    'fiance/other/contract/market/maker/param/set': 1,
    //金融部-其他管理-合约限制交易配置
    'fiance/other/contract/limit/trade/set': 1,
    'fiance/other/contract/limit/trade/list': 1,
    //金融部-其他管理-合约接单账户配置(代理商)
    'fiance/other/contract/agent/set': 1,
    'fiance/other/contract/agent/list': 1,
    //金融部-其他管理-合约接单账户关联(代理用户)
    'fiance/other/contract/agent/user/set': 1,
    'fiance/other/contract/agent/user/list': 1,
    //金融部-其他管理-合约渠道用户管理(代理商渠道)
    'fiance/other/contract/agent/channel/set': 1,
    'fiance/other/contract/agent/channel/list': 1,
    //客服部-资金管理-充值管理
    'custom/fund/deposit/record/list': 1,
    //客服部-资金管理-提现管理
    'custom/fund/withdraw/record/list': 1,
    //技术部-上币管理-上币申请
    'tech/apply/new/coin/list': 1,
    'tech/apply/new/coin/apply': 1,
    'tech/apply/new/coin/apply/cancel/self': 1,
    'tech/apply/new/coin/apply/edit': 1,
    'tech/apply/new/coin/apply/review': 1,
    'tech/apply/new/coin/apply/rewrite': 1,
    'tech/apply/new/coin/apply/cancel': 1,
    'tech/apply/new/coin/explore/url/list': 1,
    'tech/apply/new/coin/listed': 1,
    //技术部-交易上下线管理-申请上新交易对
    'tech/apply/new/pair/list': 1,
    'tech/apply/new/pair/apply': 1,
    'tech/apply/new/pair/apply/cancel/self': 1,
    'tech/apply/new/pair/apply/edit': 1,
    'tech/apply/new/pair/apply/review': 1,
    'tech/apply/new/pair/apply/rewrite': 1,
    'tech/apply/new/pair/apply/cancel': 1,
    'tech/apply/new/pair/trade/area/list': 1,
    'tech/apply/new/pair/listed': 1,
    //技术部-交易上下线管理-申请审核定时器
    'tech/apply/new/cron/list': 1,
    'tech/apply/new/cron/delete': 1,
    'tech/apply/new/cron/coin/add/deposit': 1,
    'tech/apply/new/cron/coin/add/withdraw': 1,
    //运营部-现货-现货数据
    'operate/spot/data/increase/user/list': 1,
    'operate/spot/data/trade/user/list': 1,
    'operate/spot/data/active/user/list': 1,
    'operate/spot/data/user/deposit/list': 1,
    'operate/spot/data/user/withdraw/list': 1,
    'operate/spot/data/user/depositAndWithdraw/list': 1,
    'operate/spot/data/user/gatherData': 1,
};


let filter = function (app: any) {
    app.use(function (req, res, next) {
        let path = ReqUtils.parsePath(req.originalUrl);
        try {
            //如果是非登录接口，可以直接跳过
            if (!cmdWhiteList[path]) {
                throw '3000'
            }
            next();
        }
        catch (e) {
            Logger.error(`access-limit filter error!! - ${e}`);
            return res.json(Res3Utils.getErrorResult(e));
        }
    });
};
module.exports = {
    filter: filter,
};