import * as i18nService from "../service/i18n.service";
import { I18nInfoVO, I18nInfoPageVO } from "../service/i18n.service";
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
let isIp = require('is-ip');

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

/**
 * 分页查询列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, infoPageVO: I18nInfoPageVO) => {
    let func_name = "i18nCtrl.list";
    let cmd = req.path;
    try {
        infoPageVO.page = Optional.opt(infoPageVO, 'page', 1);
        infoPageVO.size = Optional.opt(infoPageVO, 'size', 20);

        let res = await i18nService.list(infoPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 添加国际化信息
 * @param req
 * @param infoVO
 */
export const add = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.add";
    let cmd = req.path;
    try {
        await preCheck(infoVO);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await i18nService.add(infoVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 修改国际化信息
 * @param req
 * @param infoVO
 */
export const update = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.update";
    let cmd = req.path;
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await i18nService.update(infoVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 删除国际化信息
 * @param req
 * @param infoVO
 */
export const del = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.del";
    let cmd = req.path;
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await i18nService.del(infoVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 校验
 * @param infoVO
 */
async function preCheck(infoVO: I18nInfoVO) {
    if (![1, 2, 3, 4, 5].includes(infoVO.platform)) {
        throw ErrorCode.PARAM_MISS;
    }
    ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.module);
    ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.code);
    ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.lang);
    ApiAssert.notNull(ErrorCode.PARAM_MISS, infoVO.content);
}