import { systemTrigger, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface SystemTriggerVO {
    id?: number;

    trigger_symbol?: string | any;

    trigger_type?: number;

    trigger_action?: number;

    status?: number;

    trigger_time?: Date | any,

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface SystemTriggerPageVO extends SystemTriggerVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: SystemTriggerPageVO) {

    let where = {};
    if (pageVO.trigger_action) {
        where['trigger_action'] = pageVO.trigger_action
    }

    if (pageVO.trigger_symbol) {
        where['trigger_symbol'] = pageVO.trigger_symbol
    }

    if (pageVO.status || pageVO.status === 0) {
        where['status'] = pageVO.status
    }


    let resList = await systemTrigger.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["trigger_time", "desc"]],
        raw: true
    });
    return resList;
}


export async function add(systemTriggerVO: SystemTriggerVO, currentUserId: any, ip: string | undefined) {

    systemTriggerVO.createdAt = new Date();
    systemTriggerVO.updatedAt = new Date();
    if (!systemTriggerVO.status) {
        systemTriggerVO.status = 0;
    }

    await systemTrigger.prototype.create(systemTriggerVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增触发配置', ip, JSON.stringify(systemTriggerVO), '触发配置管理');
    return 'success';
}


export async function update(systemTriggerVO: SystemTriggerVO, currentUserId: any, ip: string | undefined) {
    let exist = await systemTrigger.prototype.findOne({
        where: {
            id: systemTriggerVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }


    systemTriggerVO.updatedAt = new Date();
    await systemTrigger.prototype.update(systemTriggerVO, {
        where: {
            id: Number(systemTriggerVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改触发配置', ip, JSON.stringify(systemTriggerVO), '触发配置管理');

    return 'success';
}

export async function del(id: number, currentUserId: any, ip: string | undefined) {
    let exist = await systemTrigger.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    await systemTrigger.prototype.destroy({
        where: {
            id: id
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除触发配置', ip, `id:${id}`, '触发配置管理');

    return 'success';
}



