import { ormDB, userInfo } from "@madex/ex-ts-dao";
import { requestUtils, logger } from "@madex/ex-js-public";
import { config } from "@madex/ex-js-common";
import { ErrorCode } from "../constant/errorCode";

let emailServiceUrl = config.email_service_url;

export const getMUserInfoByUid = async function (m_user_id: number) {

    let dbInfo = await userInfo.prototype.findOne({
        where: {
            user_id: m_user_id
        },
        raw: true
    });

    return dbInfo ? dbInfo : null
}

export const getMUserInfoByEmail = async function (email: string) {

    let dbInfo = await userInfo.prototype.findOne({
        where: {
            email: email
        },
        raw: true
    });

    return dbInfo ? dbInfo : null
}

export const sendEmail = async function (email: string, m_user_id: number, template: string, params?: any, lang?: string) {
    try {
        let form = {
            to: email,
            user_id: m_user_id,
            templateType: template,
            params: params ? params : "{}"
        };
        if (lang) {
            form["lang"] = lang;
        }
        requestUtils.doRequest(emailServiceUrl, form, () => {
        });
    }
    catch (e) {
        logger.error("mUserUtils.sendEmail.error:" + e);
    }
}

export const updateMUserInfo = async function (user_id: number, updateInfo: any) {
    if (!user_id || !updateInfo) {
        throw ErrorCode.PARAM_MISS;
    }
    updateInfo.updatedAt = new Date();
    await userInfo.prototype.update(updateInfo, {
        where: {
            user_id: user_id
        }
    });
}

export async function getUserInfoMapByUids(uids: number[]) {
    if (!uids.length) {
        throw ErrorCode.PARAM_MISS;
    }
    let dbInfoList = await userInfo.prototype.findAll({
        where: {
            user_id: { [ormDB.Op.in]: uids }
        },
        raw: true
    });

    let resMap = {};
    for (let item of dbInfoList) {
        resMap[item.user_id] = item
    }
    return resMap;
}