import { userApikeyStrict, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface ApikeyStrictVO {
    id?: number;

    user_id?: number;

    limit?: number;

    comment?: string;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface ApikeyStrictPageVO extends ApikeyStrictVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: ApikeyStrictPageVO) {

    let where = {};

    if (pageVO.user_id) {
        where['user_id'] = pageVO.user_id
    }


    let resList = await userApikeyStrict.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


export async function add(apikeyStrictVO: ApikeyStrictVO, currentUserId: any, ip: string | undefined) {

    apikeyStrictVO.createdAt = new Date();
    apikeyStrictVO.updatedAt = new Date();
    let dbInfo = await userApikeyStrict.prototype.findOne({
        where: {
            user_id: apikeyStrictVO.user_id
        },
        raw: true
    });
    if (dbInfo) {
        throw ErrorCode.DATA_EXIST
    }

    await userApikeyStrict.prototype.create(apikeyStrictVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增API限速', ip, JSON.stringify(apikeyStrictVO), 'API限速管理');
    return 'success';
}


export async function update(apikeyStrictVO: ApikeyStrictVO, currentUserId: any, ip: string | undefined) {
    let exist = await userApikeyStrict.prototype.findOne({
        where: {
            id: apikeyStrictVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }


    apikeyStrictVO.updatedAt = new Date();
    //不修改user_id
    apikeyStrictVO.user_id = exist.user_id;
    await userApikeyStrict.prototype.update(apikeyStrictVO, {
        where: {
            id: Number(apikeyStrictVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改API限速', ip, JSON.stringify(apikeyStrictVO), 'API限速管理');

    return 'success';
}

export async function del(id: number, currentUserId: any, ip: string | undefined) {
    let exist = await userApikeyStrict.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    await userApikeyStrict.prototype.destroy({
        where: {
            id: id
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除API限速', ip, `id:${id}`, 'API限速管理');

    return 'success';
}



