import { ormDB, userProfile } from "@madex/ex-ts-dao";


let _ = require('lodash');


export async function getProfileByUserId(user_id: number | any) {
    let dbInfo = await userProfile.prototype.findOne({
        where: {
            user_id: user_id
        },
        raw: true
    });
    return dbInfo ? dbInfo : null
}

export async function getProfileByUserIds(userIds: number[]) {

    let dbInfoList = await userProfile.prototype.findAll({
        where: {
            user_id: { [ormDB.Op.in]: userIds }
        },
        raw: true
    });
    let resMap = {};
    for (let item of dbInfoList) {
        resMap[item.user_id] = item
    }
    return resMap;
}



