export const FEE_TYPE = {
    /**
     * 费率类型： 全部。
     */
    FEE_TYPE_ALL: 0,

    /**
     * 费率类型： 币币。
     */
    FEE_TYPE_SPOT: 1,
    /**
     * 费率类型： U本位合约。
     */
    FEE_TYPE_CONTRACT: 2,

    /**
     * 费率类型： 币本位合约。
     */
    FEE_TYPE_BASE_COIN_CONTRACT: 3,

    /**
     * 费率类型： 合约（U本位+币本位）
     */
    FEE_TYPE_CONTRACT_ALL: 5,
}

export const FEE_TYPE_LIST = [FEE_TYPE.FEE_TYPE_ALL, FEE_TYPE.FEE_TYPE_SPOT, FEE_TYPE.FEE_TYPE_CONTRACT, FEE_TYPE.FEE_TYPE_BASE_COIN_CONTRACT, FEE_TYPE.FEE_TYPE_CONTRACT_ALL,]

export const FEE_STATUS = {
    /**
     * 费率设置纪录状态： 未提交。
     */
    STATUS_FEE_SETTING_NEW: 0,
    /**
     * 费率设置纪录状态： 已提交。
     */
    STATUS_FEE_SETTING_SUBMIT: 1,
    /**
     * 费率设置纪录状态： 已生效。
     */
    STATUS_FEE_SETTING_EFFECTED: 2,
    /**
     * 费率设置纪录状态： 已过期。
     */
    STATUS_FEE_SETTING_EXPIRE: 3,
    /**
     * 费率设置纪录状态： 已删除。
     */
    STATUS_FEE_SETTING_DELETED: 4,
}

/**
 * 普通用户手续费提交备注。
 */
export const COMMENT_USER_FEE_SUBMIT = "提交普通用户手续费";