import { AppVersionPageVO } from "../service/appVersion.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { ADDRESS_INFO_REDIS_KEY, ADDRESS_INFO_REDIS_KEY_OBJ, APP_SPECIAL_MODEL_REDIS_KEY, APP_VERSION_KEY } from "../../../constant/redis-val";
import { addOptLog } from "../service/userOptLog.service";

let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let isIp = require('is-ip');

interface ParamVO {
    modelName?: string,//型号

    systemVersion?: string,//系统版本

    op?: number//操作(1插入 2 删除)
}

/**
 * app特别机型配置获取详情
 * @param req
 * @param infoVO
 */
export const get = async (req: any, paramVO: ParamVO) => {
    let func_name = "appSpecialModel.control.get";
    try {
        let cacheData = await RedisClient.getSync(APP_SPECIAL_MODEL_REDIS_KEY);
        let dataList: string[] = []
        if (cacheData) {
            dataList = cacheData.split(",");
        }
        let resList: any[] = [];
        for (let item of dataList) {
            let tempArr = item.split("::");
            let one = {
                modelName: tempArr[0],
                systemVersion: tempArr[1],
            }
            resList.push(one);
        }
        return Res3Utils.result(resList);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * app特别机型配置
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, paramVO: ParamVO) => {
    let func_name = "appSpecialModel.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let modelName = String(paramVO.modelName);
        let systemVersion = String(paramVO.systemVersion);
        let op = Number(paramVO.op);
        if (!modelName || !systemVersion || ![1, 2].includes(op)) {
            throw ErrorCode.PARAM_MISS;
        }
        let cacheData = await RedisClient.getSync(APP_SPECIAL_MODEL_REDIS_KEY);
        let dataList: string[] = [];
        if (cacheData){
            let cdList = cacheData.split(",");
            for (let item of cdList) {
                dataList.push(item)
            }
        }


        let modelNameKey = modelName.concat("::").concat(systemVersion);
        if (op == 1) {//插入
            let flag: boolean = false;
            for (let item of dataList) {
                if (item == modelNameKey) {
                    flag = true
                }
            }
            if (!flag) {
                dataList.push(modelNameKey);
            }
            else {
                throw ErrorCode.DATA_EXIST
            }
        }
        else {//删除
            dataList = dataList.filter(item => item != modelNameKey);
        }
        let dataStr = dataList.join(",");
        await RedisClient.writeSync(APP_SPECIAL_MODEL_REDIS_KEY, dataStr);

        //管理后台操作日志
        addOptLog(currentUserId, 0, 'App特别机型配置', ip, `data:${dataStr}`, 'App特别机型配置');
        return Res3Utils.result('ok');
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

