import * as i18nLogService from "../service/i18nlog.service";
import { I18nInfoLogVO } from "../service/i18nlog.service";
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
let isIp = require('is-ip');

/**
 * 国际化信息修改日志列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, i18nInfoLogVO: I18nInfoLogVO) => {
    let func_name = "i18nLogCtrl.list";
    let cmd = req.path;
    try {
        i18nInfoLogVO.page = Optional.opt(i18nInfoLogVO, 'page', 1);
        i18nInfoLogVO.size = Optional.opt(i18nInfoLogVO, 'size', 20);
        let res = await i18nLogService.list(i18nInfoLogVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 还原(还原到修改之前)
 * @param req
 * @param infoVO
 */
export const revert = async (req: any, i18nInfoLogVO: I18nInfoLogVO) => {
    let func_name = "i18nLogCtrl.revert";
    let cmd = req.path;
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, i18nInfoLogVO.id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, i18nInfoLogVO.info_id);
        let res = await i18nLogService.revert(i18nInfoLogVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
