import * as userAuthConfigService from "../service/userAuthConfig.service";
import { AuthConfigVO, AuthConfigPageVO } from "../service/userAuthConfig.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";

/**
 * 重置谷歌-生成一个新的密钥返回，保存时重新绑定谷歌
 * @param req
 * @param authConfigVO
 */
export const resetTotp = async (req: any, authConfigVO: AuthConfigVO) => {
    let func_name = "userAuthConfigCtrl.resetTotp";
    let cmd = req.path;
    try {
        let res = await userAuthConfigService.resetTotp(authConfigVO.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};