import { ormDB, mainUserAsset } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import BigNumber from "bignumber.js";
import { any } from "async";
import { getUserAccountFromCore } from "../../../utils/coreSystemUtils";


let _ = require('lodash');
let { logger, BigNumberUtils } = require('@madex/ex-js-public');
let { tickerUtils } = require('@madex/ex-js-common');


export interface QueryVO {
    user_id?: number,

    symbol?: string | any;

    page?: number,

    size?: number


}


export async function walletAssetDetail(user_id: number, page: number, size: number) {
    let where = {
        user_id: user_id
    }
    let resList = await mainUserAsset.prototype.findAndCount({
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export async function assetDistribution(user_id: number) {
    let res = {
        total_asset_u: 0,
        wallet_u: {
            balance: 0,
            holds: 0
        },
        trade_u: {
            balance: 0,
            holds: 0
        }
    };
    let [walletAssetInfo, tradeAssetInfo] = await Promise.all([walletAsset2USDTByUid(user_id), tradeAsset2USDTByUid(user_id)]);
    res.wallet_u.balance = walletAssetInfo.balance_usdt;
    res.wallet_u.holds = walletAssetInfo.holds_usdt;
    res.trade_u.balance = tradeAssetInfo.balance_usdt;
    res.trade_u.holds = tradeAssetInfo.holds_usdt;

    res.total_asset_u = Number(new BigNumber(String(walletAssetInfo.balance_usdt)).add(new BigNumber(String(walletAssetInfo.holds_usdt)))
        .add(new BigNumber(String(tradeAssetInfo.balance_usdt))).add(new BigNumber(String(tradeAssetInfo.holds_usdt))).toFixed(8, 1));
    return res;
}

export async function tradeAssetsDetail(user_id: number, page: number, size: number) {
    let resList = await getUserAccountFromCore(user_id);
    return resList;
}

export async function walletAssetByUids(uids: number[]) {
    try {
        if (!uids || !uids.length) {
            throw ErrorCode.PARAM_MISS
        }
        let dbInfoList = await mainUserAsset.prototype.findAll({
            where: {
                user_id: { [ormDB.Op.in]: uids }
            }
        });
        return dbInfoList.length ? dbInfoList : []
    }
    catch (e) {
        logger.error('walletAssetByUids.error:' + e);
        throw e;
    }
}

export async function walletAsset2USDTByUids(uids: number[]) {
    try {
        let dbAssetList = await walletAssetByUids(uids);
        let usdtTickerMap = {};
        let uidAssetListMap = _.groupBy(dbAssetList, 'user_id');
        let resMap = {};
        for (let uid of uids) {
            let assetList = uidAssetListMap[uid];
            let totalBalanceUsdt: any = 0;
            let totalHoldsUsdt: any = 0;
            if (assetList && assetList.length) {
                for (let assetItem of assetList) {
                    let symbol = assetItem.symbol;
                    let balance = assetItem.balance;
                    let holds = assetItem.holds;
                    let usdt = usdtTickerMap[symbol] ? usdtTickerMap[symbol] : await tickerUtils.rateCoin2USDT(symbol);
                    //存一下 避免重复请求redis
                    usdtTickerMap[symbol] = usdt;

                    let balanceUsdt = new BigNumber(String(balance)).mul(new BigNumber(String(usdt))).toFixed(8, 1);
                    let holdsUsdt = new BigNumber(String(holds)).mul(new BigNumber(String(usdt))).toFixed(8, 1);

                    totalBalanceUsdt = new BigNumber(String(balanceUsdt)).add(new BigNumber(String(totalBalanceUsdt))).toFixed(8, 1);
                    totalHoldsUsdt = new BigNumber(String(holdsUsdt)).add(new BigNumber(String(totalHoldsUsdt))).toFixed(8, 1);
                }

            }
            resMap[uid] = {
                balance_usdt: totalBalanceUsdt,
                holds_usdt: totalHoldsUsdt,
            }

        }
        return resMap;
    }
    catch (e) {
        logger.error('walletAsset2USDTByUids.error:' + e);
        throw e;
    }
}


export async function walletAssetByUid(user_id: number) {
    try {
        if (!user_id) {
            throw ErrorCode.PARAM_MISS
        }
        let dbInfoList = await mainUserAsset.prototype.findAll({
            where: {
                user_id: user_id
            }
        });
        return dbInfoList.length ? dbInfoList : []
    }
    catch (e) {
        logger.error('walletAssetByUid.error:' + e);
        throw e;
    }
}

export async function walletAsset2USDTByUid(user_id: number) {
    try {
        let dbAssetList = await walletAssetByUid(user_id);
        let totalBalanceUsdt: any = 0;
        let totalHoldsUsdt: any = 0;
        if (dbAssetList && dbAssetList.length) {
            for (let assetItem of dbAssetList) {
                let symbol = assetItem.symbol;
                let balance = assetItem.balance;
                let holds = assetItem.holds;
                let usdt = await tickerUtils.rateCoin2USDT(symbol);

                let balanceUsdt = new BigNumber(String(balance)).mul(new BigNumber(String(usdt))).toFixed(8, 1);
                let holdsUsdt = new BigNumber(String(holds)).mul(new BigNumber(String(usdt))).toFixed(8, 1);

                totalBalanceUsdt = new BigNumber(String(balanceUsdt)).add(new BigNumber(String(totalBalanceUsdt))).toFixed(8, 1);
                totalHoldsUsdt = new BigNumber(String(holdsUsdt)).add(new BigNumber(String(totalHoldsUsdt))).toFixed(8, 1);
            }
        }
        return {
            balance_usdt: totalBalanceUsdt,
            holds_usdt: totalHoldsUsdt,
        };
    }
    catch
        (e) {
        logger.error('walletAsset2USDTByUid.error:' + e);
        throw e;
    }
}

export async function tradeAsset2USDTByUid(user_id: number) {
    try {
        let dbAssetList = await tradeAssetByUid(user_id);
        let totalBalanceUsdt: any = 0;
        let totalHoldsUsdt: any = 0;
        if (dbAssetList && dbAssetList.length) {
            for (let assetItem of dbAssetList) {
                let symbol = assetItem.name;
                let balance = assetItem.balance;
                let holds = assetItem.holds;
                let usdt = await tickerUtils.rateCoin2USDT(symbol);

                let balanceUsdt = new BigNumber(String(balance)).mul(new BigNumber(String(usdt))).toFixed(8, 1);
                let holdsUsdt = new BigNumber(String(holds)).mul(new BigNumber(String(usdt))).toFixed(8, 1);

                totalBalanceUsdt = new BigNumber(String(balanceUsdt)).add(new BigNumber(String(totalBalanceUsdt))).toFixed(8, 1);
                totalHoldsUsdt = new BigNumber(String(holdsUsdt)).add(new BigNumber(String(totalHoldsUsdt))).toFixed(8, 1);
            }
        }
        return {
            balance_usdt: totalBalanceUsdt,
            holds_usdt: totalHoldsUsdt,
        };
    }
    catch
        (e) {
        logger.error('tradeAsset2USDTByUid.error:' + e);
        throw e;
    }
}

export async function tradeAssetByUid(user_id: number) {
    try {
        let resList = await getUserAccountFromCore(user_id);
        return resList;
    }
    catch (e) {
        logger.error('tradeAssetByUid.error:' + e);
        throw e;
    }
}

export async function tradeAsset2USDTByUids(uids: number[]) {
    try {
        let dbAssetList = await tradeAssetByUids(uids);
        let usdtTickerMap = {};
        let uidAssetListMap = _.groupBy(dbAssetList, 'user_id');
        let resMap = {};
        for (let uid of uids) {
            let assetList = uidAssetListMap[uid];
            let totalBalanceUsdt: any = 0;
            let totalHoldsUsdt: any = 0;
            if (assetList && assetList.length) {
                for (let assetItem of assetList) {
                    let symbol = assetItem.name;
                    let balance = assetItem.balance;
                    let holds = assetItem.holds;
                    let usdt = usdtTickerMap[symbol] ? usdtTickerMap[symbol] : await tickerUtils.rateCoin2USDT(symbol);
                    //存一下 避免重复请求redis
                    usdtTickerMap[symbol] = usdt;

                    let balanceUsdt = new BigNumber(String(balance)).mul(new BigNumber(String(usdt))).toFixed(8, 1);
                    let holdsUsdt = new BigNumber(String(holds)).mul(new BigNumber(String(usdt))).toFixed(8, 1);

                    totalBalanceUsdt = new BigNumber(String(balanceUsdt)).add(new BigNumber(String(totalBalanceUsdt))).toFixed(8, 1);
                    totalHoldsUsdt = new BigNumber(String(holdsUsdt)).add(new BigNumber(String(totalHoldsUsdt))).toFixed(8, 1);
                }

            }
            resMap[uid] = {
                balance_usdt: totalBalanceUsdt,
                holds_usdt: totalHoldsUsdt,
            }

        }
        return resMap;
    }
    catch (e) {
        logger.error('tradeAsset2USDTByUids.error:' + e);
        throw e;
    }
}

export async function tradeAssetByUids(uids: number[]) {
    try {
        if (!uids || !uids.length) {
            throw ErrorCode.PARAM_MISS
        }
        let task: any = [];
        for (let uid of uids) {
            task.push(getUserAccountFromCore(uid));
        }
        let taskResList = await Promise.all(task);
        let dbInfoList: any = [];

        for (let i = 0; i < uids.length; i++) {
            let oneUserAssetList = taskResList[i];
            if (oneUserAssetList.length) {
                for (let item of oneUserAssetList) {
                    item.user_id = uids[i];
                    dbInfoList.push(item);
                }
            }

        }
        return dbInfoList.length ? dbInfoList : []
    }
    catch (e) {
        logger.error('tradeAssetByUids.error:' + e);
        throw e;
    }
}








