// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { userInfo } from "@madex/ex-ts-dao";

// 可以直接引用原有 js 封装的工具, 但是目前 js 的库没有类型提示
// 后面吧 common 用 ts 改一下就行了
const { redisUtilsCommon } = require('@madex/ex-js-common');

export interface UserPayload {
    email: string;

    name: string;

    user_id: string;
}

export const getUserInfo = async (payload: UserPayload) => {
    const key = "ts-api-demo:user"
    const result = await redisUtilsCommon.getSync(key)
    if (result) {
        return {
            user: result
        }
    }
    const dbUser = await userInfo.prototype.findOne({
        where: {
            user_id: payload.user_id
        },
        raw: true
    });
    if (dbUser) {
        await redisUtilsCommon.writeSync(key, dbUser, 5)
    }
    return {
        user: dbUser
    }
};
