import { aclUserOptLog } from "@madex/ex-ts-dao";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger } = require('@madex/ex-js-public');


/**
 *
 * @param current_user_id  当前登陆用户的ID
 * @param opt_user_id   操作的目标用户的UID
 * @param opt_info      操作信息(添加、修改、审核、删除...)
 * @param ip            ip (传空的话，就默认 0.0.0.0)
 * @param opt_detail    操作详情
 * @param module        操作模块
 * @param session_id    session_id 可选 有 current_user_id 无需传
 */
export const addOptLog = async function (current_user_id: number | any, opt_user_id: number,
                                         opt_info: string, ip: string | any, opt_detail: string, module: string, session_id?: any) {
    try {
        if ((!current_user_id && !session_id)) {
            throw 'current_user_id or session_id or opt_detail is null'
        }
        if (!current_user_id) {
            current_user_id = await getCurrentUserId(session_id);
        }
        let detail = {
            ip: ip ? ip : '0.0.0.0',
            detail: opt_detail ? opt_detail : ''
        }
        await aclUserOptLog.prototype.create({
            user_id: current_user_id,
            opt_user_id: opt_user_id ? opt_user_id : 0,
            opt_info: opt_info ? opt_info : "",
            opt_detail: JSON.stringify(detail),
            module: module ? module : "",
            createdAt: new Date(),
            updatedAt: new Date(),
        })
    }
    catch (e) {
        logger.error('optLogService.addOptLog.error:' + e)
    }
}