import { ErrorCode } from "../constant/errorCode";
import { coinType } from "@madex/ex-ts-dao";

/**
 * 检查交易对中的币种是否存在于coin_type 中
 * @param pair
 */
export const checkPairInCoinType = async function (pair: string) {
    if (!pair) {
        throw ErrorCode.PARAM_MISS;
    }
    let coin_symbol = pair.split('_')[0];
    let currency_symbol = pair.split('_')[1];
    if (!coin_symbol || !currency_symbol) {
        throw ErrorCode.PAIR_FORMAT_ERR;
    }

    let dbSymbolTask = coinType.prototype.findOne({
        where: { symbol: coin_symbol },
        raw: true
    });
    let dbCurrencyTask = coinType.prototype.findOne({
        where: { symbol: currency_symbol },
        raw: true
    });

    let [dbSymbol, dbCurrency] = await Promise.all([dbSymbolTask, dbCurrencyTask]);

    if (!dbSymbol) {
        throw ErrorCode.COIN_DATA_NOT_EXIST;
    }
    if (!dbCurrency) {
        throw ErrorCode.CURRENT_COIN_DATA_NOT_EXIST;
    }
}