import Express from "express"

const router = Express.Router();

const { logger, responsedata, errorCodeConst: errCode, errorCodeDefine } = require('@broker/nodejs_common');
const { getError, isValidResponseData } = responsedata;

import * as userController from "../../mvc/control/user.control"

const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = req.path ? req.path.slice(1) : '';
    if (!path) {
        return res.json(getError(errCode.CODE_NEED_ROUTER));
    }

    if (!getFunc[path]) {
        return res.json(getError(errCode.CODE_UNDEFINE_ROUTER));
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    const path = req.path ? req.path.slice(1) : '';
    if (!path) {
        return res.json(getError(errCode.CODE_NEED_ROUTER));
    }

    if (!postFunc[path]) {
        return res.json(getError(errCode.CODE_UNDEFINE_ROUTER));
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.warn(_func_name_, err);
        if (isValidResponseData(err)) {
            res.json(err);
            return;
        }
        if (!err || !errorCodeDefine[err]) {
            err = errCode.CODE_INTERNAL;
        }
        res.json(getError(err));
    });
};

export const apiRouterV1 = router;
