import express, { Request, Response, NextFunction } from 'express';
import errorHandler from 'errorhandler';
import morgan from 'morgan';
import { logger, expressSetting } from '@broker/nodejs_common';
import appConfig from "./config";
import { apiRouterV1 } from "./src/router/v1";

const app = express();

expressSetting(app);
app.use(morgan('dev'));

if (appConfig.node_env === 'development') {
    app.use(errorHandler());
}
else {
    app.use((err: any, req: Request, res: Response, next: NextFunction) => {
        res.status(500).send("500 error");
    });
}

app.use('/demo/v1', apiRouterV1);

app.listen(appConfig.port, '0.0.0.0', () => {
    logger.info(
        'MyToken-(api) server listening on %d, in %s mode',
        appConfig.port,
        app.get('env'),
    );
});
