import * as aclUserService from "../service/aclUser.service";
import { AclUserInfoVO, AclUserInfoPageVO } from "../service/aclUser.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId, isAdminUserBySessionId } from "../../../utils/aclUserUtils";

/**
 * 分页查询用户列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, aclUserInfoPageVO: AclUserInfoPageVO) => {
    let func_name = "aclUserCtrl.list";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        aclUserInfoPageVO.page = Optional.opt(aclUserInfoPageVO, 'page', 1);
        aclUserInfoPageVO.size = Optional.opt(aclUserInfoPageVO, 'size', 20);
        let res = await aclUserService.list(aclUserInfoPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 添加用户信息
 * @param req
 * @param infoVO
 */
export const add = async (req: any, aclUserInfoVO: AclUserInfoVO) => {
    let func_name = "aclUserCtrl.add";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        await preCheck(aclUserInfoVO);
        let res = await aclUserService.add(aclUserInfoVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 修改用户信息
 * @param req
 * @param infoVO
 */
export const update = async (req: any, aclUserInfoVO: AclUserInfoVO) => {
    let func_name = "aclUserCtrl.update";
    let cmd = req.path;
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.user_id);
        await isAdminUserBySessionId(req.cookies.session_id);
        let res = await aclUserService.update(aclUserInfoVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 修改用户状态
 * @param req
 * @param infoVO
 */
export const updateStatus = async (req: any, aclUserInfoVO: AclUserInfoVO) => {
    let func_name = "aclUserCtrl.updateStatus";
    let cmd = req.path;
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.user_id);
        await isAdminUserBySessionId(req.cookies.session_id);
        let res = await aclUserService.updateStatus(aclUserInfoVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 重置密码
 * @param req
 * @param infoVO
 */
export const resetPwd = async (req: any, aclUserInfoVO: AclUserInfoVO) => {
    let func_name = "aclUserCtrl.resetPwd";
    let cmd = req.path;
    try {
        ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.user_id);
        await isAdminUserBySessionId(req.cookies.session_id);
        let res = await aclUserService.resetPwd(aclUserInfoVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 校验
 * @param infoVO
 */
async function preCheck(aclUserInfoVO: AclUserInfoVO) {
    ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.account);
    ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.user_type);
    ApiAssert.notNull(ErrorCode.PARAM_MISS, aclUserInfoVO.remark);
}

