import * as userAuthConfigService from "../service/userAuthConfig.service";
import { AuthConfigVO, AuthConfigPageVO } from "../service/userAuthConfig.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId, isAdminUserBySessionId } from "../../../utils/aclUserUtils";

/**
 * 分页查询用户安全项配置列表
 * @param req
 * @param infoVO
 */
export const authConfigList = async (req: any, authConfigPageVO: AuthConfigPageVO) => {
    let func_name = "userAuthConfigCtrl.queryConfigList";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        authConfigPageVO.page = Optional.opt(authConfigPageVO, 'page', 1);
        authConfigPageVO.size = Optional.opt(authConfigPageVO, 'size', 20);
        let res = await userAuthConfigService.queryConfigList(authConfigPageVO.user_id, authConfigPageVO.user_type,
            authConfigPageVO.page, authConfigPageVO.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 开启、关闭指定账户的"强制绑定谷歌"属性
 * @param req
 * @param infoVO
 */
export const changeForceStatus = async (req: any, authConfigVO: AuthConfigVO) => {
    let func_name = "userAuthConfigCtrl.changeForceStatus";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, authConfigVO.user_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, authConfigVO.force);
        let res = await userAuthConfigService.changeForceStatus(Number(authConfigVO.user_id), authConfigVO.force);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 解锁指定账户
 * @param req
 * @param infoVO
 */
export const changeLockedStatus = async (req: any, authConfigVO: AuthConfigVO) => {
    let func_name = "userAuthConfigCtrl.changeLockedStatus";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, authConfigVO.user_id);
        //暂时只支持解锁
        let res = await userAuthConfigService.changeLockedStatus(authConfigVO.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 清除谷歌验证
 * @param req
 * @param authConfigVO
 */
export const resetTotp = async (req: any, authConfigVO: AuthConfigVO) => {
    let func_name = "userAuthConfigCtrl.resetTotp";
    let cmd = req.path;
    try {
        await isAdminUserBySessionId(req.cookies.session_id);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, authConfigVO.user_id);
        let res = await userAuthConfigService.resetTotp(authConfigVO.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};