import * as aclPositionService from "../service/aclPosition.service";
import { AclAuthVO, AclAuthPageVO, AclRolePageVO, AclRoleVO } from "../service/aclRoleAuth.service";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";
import { ErrorCode } from "../../../constant/errorCode";
import { getUserOrdersFromCore } from "../../../utils/coreSystemUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

export interface QueryVo {
    update_id?: string

    is_next?: number//1 下一页

    size?: number

    user_id?: number
}

export const pendingList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
        status: "unsettled"//当前委托
    }
    let res = await getUserOrdersFromCore(param);
    return res;
};

export const historyList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
        status: "settled"//历史委托
    }

    let res = await getUserOrdersFromCore(param);
    Array.isArray(res);
    return res;
};



