import { coinType } from "@madex/ex-ts-dao";

const axios = require("axios");
const _ = require("lodash");

import  configSetting  from "./../../config"
const webadmin_endpoint = configSetting.webadmin_endpoint
let { logger } = require('@madex/ex-js-public');

// { id: 1, symbol: 'BTC' }
export const getCoinFromCore = async(symbol)=> {
    const url = `${webadmin_endpoint}/asset/by_symbol?symbol=${symbol}`
    let { data } = await axios.get(url);
    if (data.error) {
        logger.error("getCoinFromCore",data);
        return null
    }
    return data[0];
}

// {
//     "id": 1,
//      "symbol": 'BTC_USDT',
//     'price-scale': 4,
//     'price-increment': 1,
//     'quantity-scale': 2,
//     'quantity-increment': '0'
// }
export const getPairFromCore = async(symbol,market="spot")=> {
    const url = `${webadmin_endpoint}/pair/by_symbol?symbol=${symbol}&market=${market}`
    let { data } = await axios.get(url);
    if (data.error) {
        logger.error("getPairFromCore",data);
        return null
    }
    return data[0]
}

// res：
// [{"name":"BTC","asset":1,"balance":"10","holds":"0"}]
export const getUserAccountFromCore = async(userId,withName = true)=> {
    const url = `${webadmin_endpoint}/account/list?user_id=${userId}`
    let { data } = await axios.get(url);
    if (data.error) {
        logger.error("getPairFromCore",data);
        return null
    }
    let asset_id = _.map(data,'asset');
    if (withName) {
        let names = await coinType.prototype.findAll({
            attributes:['general_name','asset_id'],
            where:{
                asset_id,
                is_main:1
            },
            raw:true
        })
        let m = _.keyBy(names,'asset_id');
        for (const item of data) {
            if (m[item.asset]) {
                item.name = m[item.asset].general_name
            }
        }
    }
    // console.log(data)

    return data;
}

// user_id
// status, // 必须 unsettled或者settled
// symbol, // 可选，交易对
// start_time, // 成交时间
// end_time, // 成交时间
// before, // update_id
// after, // update_id
// limit, / 数量
// res:
// [{"orderId":"4611689316962271233","clientOrderId":"","createTime":"1725261917795","product":"BTC_USDT","type":1,"side":"buy","quantity":"1","stf":"disabled","price":"9999.0000","visibleQty":"1","timeInForce":"gtc","cancelAfter":0,"postOnly":false,"status":"accepted","executedQty":"0","fillCount":0,"fills":[],"fees":[],"updateTime":"1725261917795"},{"orderId":"4611689316962271234","clientOrderId":"","createTime":"1725261919337","product":"BTC_USDT","type":1,"side":"buy","quantity":"1","stf":"disabled","price":"9998.0000","visibleQty":"1","timeInForce":"gtc","cancelAfter":0,"postOnly":false,"status":"accepted","executedQty":"0","fillCount":0,"fills":[],"fees":[],"updateTime":"1725261919337"}]
export const getUserOrdersFromCore = async(params)=> {
    // let params = new URLSearchParams();
    const url = `${webadmin_endpoint}/order/list`
    let { data } = await axios.get(url,{params});
    if (data.error) {
        logger.error("getPairFromCore",data);
        return null
    }
    console.log(data)
    return data
}

// getUserOrdersFromCore({user_id:1})

export const addCoin2Core = async(symbol,id)=> {
    const url = `${webadmin_endpoint}/asset/add`
    let body =  {
        "symbol":symbol,
        "id":id,
    }
    let { data } = await axios.post(url,body);
    if (data.error) {
        logger.error(data);
        return false;
    }
    return true;
}

export const addPairToCore = async(body)=> {
    const url = `${webadmin_endpoint}/pair/add_product`
    let { data } = await axios.post(url,body);
    if (data.error) {
        logger.error(data);
        return false;
    }
    return true;
}

