// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { spotPairs, ormDB, coinType } from "@madex/ex-ts-dao";
import { NUMBER } from "sequelize";
import { addPairToCore } from "../../../utils/coreSystemUtils";


export interface ListParam {
    symbol: string | any;

    page: number;

    size: number;
}

export interface AddParam {
    id: any;

    base: string;

    quote: string;

    symbol: string;

    name: string;

    price_scale: number;

    quantity_scale: number;

    maker_fee: string;

    taker_fee: string;
}


export async function list(param: ListParam) {
    let where = {};
    if (param.symbol) {
        where["symbol"] = { [ormDB.Op.like]: `%${param.symbol}%` };
    }
    let resList = await spotPairs.prototype.findAndCount({
        where: where,
        limit: param.size,
        offset: (Number(param.page) - 1) * Number(param.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export const save = async (param: AddParam) => {
    let id = param.id;
    if (id) {
        delete param.id
        await spotPairs.prototype.update(param, {
            where: { id: id }
        })
    }
    else {
        await spotPairs.prototype.create(param);
    }
    return 'ok';
};

export const pushToCoreSystem = async (id: any) => {
    let where = { id: id, status: 0 };

    let cfg = await spotPairs.prototype.find({
        where: where, raw: true
    });
    if (cfg) {
        let symbol = cfg.symbol;
        let sps = symbol.split("_");
        let base = sps[0];
        let quote = sps[1]
        let param = {
            "base": base, "quote": quote, "symbol": symbol, "name": symbol,
            "price_scale": cfg.price_scale, "quantity_scale": cfg.quantity_scale,
            "maker_fee": cfg.maker_fee, "taker_fee": cfg.taker_fee
        }
        let optResult = await addPairToCore(param);
        if (optResult) {
            await spotPairs.prototype.update({ status: 1 }, {
                where: where
            });
        }
    }

    return 'ok';
};

export async function getAllSubmitSuccess() {
    let resList = await spotPairs.prototype.findAll({
        where: {
            status: 2
        },
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


