import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as userController from "../../mvc/control/user.control";
import * as i18nCtrl from "../../mvc/control/i18n.control";
import * as i18nLogCtrl from "../../mvc/control/i18nlog.control";
import * as  aclUserCtrl from "../../mvc/control/aclUser.control";
import * as  aclRoleAuthCtrl from "../../mvc/control/aclRoleAuth.control";
import * as  userOptCtrl from "../../mvc/control/userOpt.control";
import * as  userAuthConfigCtrl from "../../mvc/control/userAuthConfig.control";
import * as ReqUtils from "../../../utils/req-utils";

import * as spotPairCtrl from "../../mvc/control/spotPair.control";
import * as coinTypeCtrl from "../../mvc/control/coinType.control";
const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {
    'i18n/info/list': i18nCtrl.list,
    'i18n/info/add': i18nCtrl.add,
    'i18n/info/update': i18nCtrl.update,
    'i18n/info/del': i18nCtrl.del,

    'i18n/info/log/list': i18nLogCtrl.list,
    'i18n/info/log/revert': i18nLogCtrl.revert,

    'spotPair/add': spotPairCtrl.save,
    'spotPair/list': spotPairCtrl.list,
    'spotPair/spotPairCtl': spotPairCtrl.pushToCoreSystem,

    'coinType/add': coinTypeCtrl.save,
    'coinType/list': coinTypeCtrl.list,
    'coinType/spotPairCtl': coinTypeCtrl.pushToCoreSystem,

    'acl/user/add': aclUserCtrl.add,
    'acl/user/list': aclUserCtrl.list,
    'acl/user/update': aclUserCtrl.update,
    'acl/user/updateStatus': aclUserCtrl.updateStatus,
    'acl/user/resetPwd': aclUserCtrl.resetPwd,

    'acl/auth/list': aclRoleAuthCtrl.authList,
    'acl/auth/tree': aclRoleAuthCtrl.getAuthTree,
    'acl/auth/getByUser': aclRoleAuthCtrl.getAuthByUser,
    'acl/auth/getByRole': aclRoleAuthCtrl.getAuthByRole,
    'acl/auth/save': aclRoleAuthCtrl.saveAuth,
    'acl/auth/del': aclRoleAuthCtrl.delAuth,

    'acl/role/list': aclRoleAuthCtrl.roleList,
    'acl/role/getByUser': aclRoleAuthCtrl.getRoleByUser,
    //'acl/role/getUserList':aclUserCtrl.list,
    'acl/role/getAll': aclRoleAuthCtrl.getAllRole,
    'acl/role/save': aclRoleAuthCtrl.saveRole,
    'acl/role/del': aclRoleAuthCtrl.delRole,

    'acl/changeRoleAuth': aclRoleAuthCtrl.changeRoleAuth,
    'acl/changeUserRole': aclRoleAuthCtrl.changeUserRole,

    'user/getInfo': userOptCtrl.getInfo,
    'user/login': userOptCtrl.login,
    'user/logout': userOptCtrl.logout,
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/updatePwd': userOptCtrl.updatePwd,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,

    'user/auth/config/list': userAuthConfigCtrl.authConfigList,
    'user/auth/change/force/status': userAuthConfigCtrl.changeForceStatus,
    'user/auth/change/locked/status': userAuthConfigCtrl.changeLockedStatus,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,


};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!getFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV1 = router;
