import * as contractMarketMakerService from "../service/contractMarketMaker.service";
import { MakerPairPageVO, MakerPairVO } from "../service/contractMarketMaker.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 金融部-其他管理-合约做市参数配置列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: MakerPairPageVO) => {
    let func_name = "contractMarketMaker.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await contractMarketMakerService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约做市参数配置-交易对
 * @param req
 * @param authConfigVO
 */
export const set = async (req: any, makerPairVO: MakerPairVO) => {
    let func_name = "contractMarketMaker.control.set";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!makerPairVO.pair || !makerPairVO.user_id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractMarketMakerService.set(makerPairVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约做市参数配置-做市参数配置
 * @param req
 * @param authConfigVO
 */
export const paramSet = async (req: any, makerPairVO: MakerPairVO) => {
    let func_name = "contractMarketMaker.control.paramSet";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!makerPairVO.pair || !makerPairVO.data) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractMarketMakerService.paramSet(makerPairVO.pair, makerPairVO.data, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约做市参数配置-做市参数查询
 * @param req
 * @param authConfigVO
 */
export const paramGet = async (req: any, makerPairVO: MakerPairVO) => {
    let func_name = "contractMarketMaker.control.paramGet";
    try {
        if (!makerPairVO.pair) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractMarketMakerService.paramGet(makerPairVO.pair);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



