let {
    debug,
    logger
} = require('@madex/ex-js-public');

import Config from "../../config";

let axios = require('axios');


debug = Config.node_env == "development";

/**
 * Lark 地址
 */
let LARK_URL_PRE = "https://open.larksuite.com/open-apis/bot/v2/hook/";

/**
 * 生产:pro
 */
let COMMON_KEY = "d9f2dc6e-52cf-4933-92f1-dab9c249aa28";


/**
 * 资产管理后台通知
 */
let ABK_KEY = "d0edce37-1798-4648-bd87-45b7a5ae5c64";

/**
 * 测试:dev
 */

if (debug) {
    COMMON_KEY = "d98c9942-ff6f-4e71-a77f-41647ff19ff0";
    ABK_KEY = "d98c9942-ff6f-4e71-a77f-41647ff19ff0";
}

export const ROBOT_KEYS = {
    COMMON_KEY: COMMON_KEY,
    ABK_KEY: ABK_KEY,
}
/**
 *
 * @param url 机器人链接 （必填）
 * @param content 发送内容（必填）
 * @param _func_name_ 报错方法（可选）
 */
export const sendRobotMessage = async function (url: string, content: any, _func_name_?: string) {
    if (!_func_name_) {
        _func_name_ = '';
    }
    if (typeof content != 'string') {
        if (content && content.sql) {
            content = `backend._func_name_ ${_func_name_}, ${content.sql}`;
        }
        else if (content && content.message) {
            content = `backend._func_name_ ${_func_name_}, ${content.message}`;
        }
        else {
            content = `backend._func_name_ ${_func_name_}, ${JSON.stringify(content)}`;
        }
    }
    else {
        content = `backend._func_name_ ${_func_name_}, ${content}`;
    }

    if (debug) {
        content = `backend.测试.${content}`;
        await doSend(COMMON_KEY, content);
    }
    else {
        await doSend(url, content);
    }

}

async function doSend(url: string, content: any) {
    logger.info('robot message', url, content);
    let URL = LARK_URL_PRE + url;
    try {
        let response = await axios.post(URL, {
            msg_type: "text",
            content: { text: content }
        });
        if (response && response.data) {
            return response.data
        }
    }
    catch (e) {
        logger.error('robot send error', URL, content);
    }
}
