import * as contractAgentService from "../service/contractAgent.service";
import { AgentVO, AgentUserVO, AgentPageVO } from "../service/contractAgent.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 金融部-其他管理-合约接单账户配置列表
 * @param req
 * @param AgentPageVO
 */
export const agentList = async (req: any, pageVO: AgentPageVO) => {
    let func_name = "contractAgent.control.agentList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await contractAgentService.agentList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约接单账户配置
 * @param req
 * @param authConfigVO
 */
export const agentSet = async (req: any, vo: AgentUserVO) => {
    let func_name = "contractAgent.control.agentSet";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if ( !vo.user_id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractAgentService.agentSet(vo, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约接单账户对冲列表
 * @param req
 * @param AgentPageVO
 */
export const hedgeRatioList = async (req: any, vo: AgentUserVO) => {
    let func_name = "contractAgent.control.agentList";
    try {

        if (!vo.agent_id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractAgentService.hedgeRatioList(vo.agent_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约接单账户配置对冲
 * @param req
 * @param AgentUserVO
 */
export const hedgeRatioSet = async (req: any, agentUserVO: AgentUserVO) => {
    let func_name = "contractAgent.control.hedgeRatioSet";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if ( !agentUserVO.agent_id || !agentUserVO.product || !agentUserVO.ratio) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractAgentService.hedgeRatioSet(agentUserVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约接单账户关联列表
 * @param req
 * @param infoVO
 */
export const agentUserList = async (req: any, pageVO: AgentPageVO) => {
    let func_name = "contractAgent.control.agentUserList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await contractAgentService.agentUserList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约接单账户关联
 * @param req
 * @param authConfigVO
 */
export const agentUserSet = async (req: any, agentUserVO: AgentUserVO) => {
    let func_name = "contractAgent.control.agentUserSet";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!agentUserVO.user_id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractAgentService.agentUserSet(agentUserVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 金融部-其他管理-合约渠道用户管理列表
 * @param req
 * @param infoVO
 */
export const agentChannelList = async (req: any, pageVO: AgentPageVO) => {
    let func_name = "contractAgent.control.agentChannelList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await contractAgentService.agentChannelList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-其他管理-合约渠道用户管理
 * @param req
 * @param authConfigVO
 */
export const agentChannelSet = async (req: any, agentUserVO: AgentUserVO) => {
    let func_name = "contractAgent.control.agentChannelSet";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!agentUserVO.agent_id || !agentUserVO.user_id) {
            throw ErrorCode.PARAM_MISS
        }

        let res = await contractAgentService.agentChannelSet(agentUserVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};




