import * as pairApplyService from "../service/pairApply.service";
import { PairApplyVO, PairApplyPageVO } from "../service/pairApply.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUser, getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 技术部-交易上下线管理-申请上新交易对列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: PairApplyPageVO) => {
    let func_name = "pairApply.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await pairApplyService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * TODO:现在没用   之后需要 再确认 现在查询的是spot_pairs  原来是ex_pair 后期是否需要调整？
 * 技术部-交易上下线管理-已有交易对列表
 * @param req
 * @param infoVO
 */
export const listed = async (req: any, pageVO: PairApplyPageVO) => {
    let func_name = "pairApply.control.listed";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await pairApplyService.listed(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 技术部-交易上下线管理-申请上新交易对
 * @param req
 * @param authConfigVO
 */
export const apply = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.apply";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        await paramValid(pairApplyVO);

        let res = await pairApplyService.apply(pairApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-编辑上新交易对
 * @param req
 * @param authConfigVO
 */
export const edit = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.edit";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!pairApplyVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(pairApplyVO);
        let res = await pairApplyService.edit(pairApplyVO, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 技术部-交易上下线管理-撤销申请上新交易对
 * @param req
 * @param authConfigVO
 */
export const cancelSelf = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.cancelSelf";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!pairApplyVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await pairApplyService.cancelSelf(pairApplyVO.id, pairApplyVO.reason, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 技术部-交易上下线管理-驳回申请上新交易对
 * @param req
 * @param authConfigVO
 */
export const rewrite = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.rewrite";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!pairApplyVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await pairApplyService.rewrite(pairApplyVO.id, pairApplyVO.reason, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 技术部-交易上下线管理-管理员取消申请上新新交易对
 * @param req
 * @param authConfigVO
 */
export const cancel = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.cancel";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!pairApplyVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await pairApplyService.cancel(pairApplyVO.id, pairApplyVO.reason, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 技术部-交易上下线管理-审核申请上新新交易对
 * @param req
 * @param authConfigVO
 */
export const review = async (req: any, pairApplyVO: PairApplyVO) => {
    let func_name = "pairApply.control.review";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUser = await getCurrentUser(req.cookies.session_id);
        if (!pairApplyVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await pairApplyService.review(pairApplyVO.id, currentUser, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function paramValid(pairApplyVO: PairApplyVO) {
    if (!pairApplyVO.type || !pairApplyVO.symbol
        || !pairApplyVO.name || !pairApplyVO.price_scale
        || !pairApplyVO.quantity_scale || !pairApplyVO.maker_fee
        || !pairApplyVO.taker_fee) {
        throw ErrorCode.PARAM_MISS;
    }
    //申请上合约交易对
    if (pairApplyVO.type == 2) {
        if (!pairApplyVO.settlement_asset || !pairApplyVO.default_initial_margin
            || !pairApplyVO.base_initial_margin || !pairApplyVO.base_maintenance_margin
            || !pairApplyVO.base_interest || !pairApplyVO.quote_interest
            || !pairApplyVO.impact_notional || !pairApplyVO.base_risk_limit
            || !pairApplyVO.risk_limit_step) {
            throw ErrorCode.PARAM_MISS;
        }
    }

    if (!pairApplyVO.business_area_id) {
        pairApplyVO.business_area_id = 0
    }
    let tm = datetimeUtils.add(new Date(), datetimeUtils.SECONED * 10);
    if (!pairApplyVO.tm_active
        || datetimeUtils.between(pairApplyVO.tm_active, tm) < 0) {
        throw ErrorCode.PARAM_MISS;
    }
}

