let { ossUtils } = require('@madex/ex-js-common');
let { logger } = require('@madex/ex-js-public');
const sizeOf = require('image-size');
const axios = require("axios");
/**
 * 获取访问链接
 * @param url
 */
export const getKycImageUrl = async function (url: string) {
    return await getSignatureUrl(url)
}

/**
 * 获取签名后的图片链接
 * @param url
 * @param style
 */
async function getSignatureUrl(url: string, style?: string | any) {
    let res: string | any;
    let newUrl = url.replace(/^\/+/, '');
    if (style) {
        res = await ossUtils.getUrlResize(newUrl, style);
    }
    else {
        res = await ossUtils.getUrl(newUrl);
    }
    return res;
}

export const resizeWithWaterMark = async function (url: string, text: string, font_size?: number) {
    let style = await watermarkStyle(text, font_size ? font_size : 60)
    return await getSignatureUrl(url, style);
}


export const getImageWidth = async function (urlStr: string) {
    try {
        let response = await axios({
            url: urlStr,
            method: 'GET',
            responseType: 'arraybuffer'
        });
        let dimensions = sizeOf(response.data);
        let width = dimensions ? dimensions.width : 0;
        return width;
    }
    catch (e) {
        logger.error("OSSUtils.getImageWidth.error:" + e);
        return 0;
    }
}

export const withWaterMark = async function (url: string, text: string) {
    let imgUrl = await getKycImageUrl(url);
    let imageWidth = await getImageWidth(imgUrl);
    if (imageWidth <= 0) {
        imageWidth = 1000;
    }
    let fontSize = Math.round((imageWidth / 5));
    if (fontSize > 999) {
        fontSize = 999;
    }
    let style = await watermarkStyle(text, fontSize);
    return await getSignatureUrl(url, style);
}


export const watermarkStyle = async function (text: string, font_size?: number) {
    let base64 = Buffer.from(text).toString('base64');
    let textWatermark = base64.replace("+", "-").replace('/', '_').replace("=", "");
    return "/watermark,text_" + textWatermark + ",g_center,x_10,y_10,t_10,fill_1,color_FFFFFF,size_" + font_size ? font_size : "";
}


