// 配置文件暂时和 js 的导出方式保持一致，涉及到线上环境变量的替换等
import _ from 'lodash';

const env = process.env.NODE_ENV ? process.env.NODE_ENV : 'development';
const config_file = './config.' + env;

const common_config = require('@madex/ex-js-common').config;

export default _.merge(
    {
        env
    },
    require(config_file),
    common_config,
    {
        port: 8080,          //服务端口
        contractData: {}
    },
    {
        LOGIN_ERROR_LIMIT: 10,
        LOGIN_EXPIRED: 16 * 60 * 60,
        LOGIN_IP_LIMIT: 40,
        MIN_RATIO_LIMIT: 0, // 由0.01 =>变为0
        MAX_RATIO_LIMIT: 1,
    },
);