import { ormDB, appVersion, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface AppVersionVO {
    id?: number;

    version?: string | any;

    status?: number;

    device_type?: number;

    version_url?: string;

    download_url?: string;

    comment?: string;

    comment_en?: string;

    platform?: number,

    grayscale_value?: number,

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface AppVersionPageVO extends AppVersionVO {

    page?: number,

    size?: number,

    type?: string,

}


export async function list(pageVO: AppVersionPageVO) {

    let where = {};
    if (pageVO.version) {
        where['version'] = pageVO.version
    }
    if (pageVO.status || pageVO.status === 0) {
        where['status'] = pageVO.status
    }
    if (pageVO.device_type) {
        where['device_type'] = pageVO.device_type
    }


    let resList = await appVersion.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["createdAt", "desc"]],
        raw: true
    });
    return resList;
}


export async function add(appVersionVO: AppVersionVO, currentUserId: any, ip: string | undefined) {
    let dbInfo = await appVersion.prototype.findOne({
        where: {
            device_type: appVersionVO.device_type,
            version: appVersionVO.version,
            platform: appVersionVO.platform,
        },
        raw: true
    });
    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    appVersionVO.createdAt = new Date();
    appVersionVO.updatedAt = new Date();

    await appVersion.prototype.create(appVersionVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增App版本', ip, JSON.stringify(appVersionVO), 'App版本管理');

    return 'success';
}


export async function update(appVersionVO: AppVersionVO, currentUserId: any, ip: string | undefined) {
    let exist = await appVersion.prototype.findOne({
        where: {
            id: appVersionVO.id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST
    }

    let dbInfo = await appVersion.prototype.findOne({
        where: {
            device_type: appVersionVO.device_type,
            version: appVersionVO.version,
            platform: appVersionVO.platform,
        },
        raw: true
    });
    if (dbInfo && dbInfo.id != appVersionVO.id) {
        throw ErrorCode.DATA_EXIST;
    }

    appVersionVO.updatedAt = new Date();
    await appVersion.prototype.update(appVersionVO, {
        where: {
            id: Number(appVersionVO.id)
        }
    })

    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改App版本', ip, JSON.stringify(appVersionVO), 'App版本管理');

    return 'success';
}



