import WebSocket from 'ws';

const client = new WebSocket('ws://127.0.0.1:8443?sid=12312',[],{"headers":{"api-key":111}});

// 心跳
let heartbeatInterval: any;
const heartbeatConfig = {
    interval: 30000, // 心跳间隔
};
function heartBeat (){
    console.log(new Date() +" send ping...")
    client.ping()
}

client.on('error', console.error);

client.on('open', function open() {
    console.log("success open!")

    if (heartbeatInterval) {
        clearInterval(heartbeatInterval);
    }
    heartbeatInterval = setInterval(heartBeat, heartbeatConfig.interval); // 设置心跳
});

client.on('message', function message(data) {
    console.log('received: %s', data);
});

client.on('onclose', function message(data) {
    if (heartbeatInterval) {
        clearInterval(heartbeatInterval); // 清除心跳定时器
    }
    console.log('Connection closed');
});

client.on('pong',function (){
    console.log("rec pong")
})