import { ormDB, dwdMadOrmDB, mainUserAsset, dwdExLedger, coinTx, coinWithdraw, mainUserBills } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import BigNumber from "bignumber.js";
import { any } from "async";
import { getUserAccountFromCore } from "../../../utils/coreSystemUtils";
import { dealReturnData } from "./depositAndWithdraw.service";


let _ = require('lodash');
let { logger, BigNumberUtils } = require('@madex/ex-js-public');
let { tickerUtils, billsDefineTreeNewUtils } = require('@madex/ex-js-common');


export interface QueryVO {
    user_id?: number,

    symbol?: string | any;

    account_type: number,//1 钱包账户  2 交易账户

    page?: number,

    size?: number

    from_time?: any

    to_time?: any

    type?: string

}


export async function billTypeList(account_type: number) {
    let body: any = {
        type: []
    };
    //pid 对应 bills_define_tree_new 的根节点id
    let pid: any;
    if (account_type == 1) {
        pid = 1;//钱包账户
    }
    else {
        pid = 224;//交易账户
    }
    //billsTreeDealWithBody() 会处理 body.type
    let [tmp, typesMap] = await Promise.all([billsDefineTreeNewUtils.billsTreeDealWithBody(pid, body), getBillTypesMap()]);
    let bill_type_arr = body.type;
    bill_type_arr = bill_type_arr.filter(item => item >= 0);
    let res: any = {};
    for (let oneType of bill_type_arr) {
        res[oneType] = typesMap[oneType] ? typesMap[oneType] : "";
    }
    return res;
}


export async function billDetailList(queryVO: QueryVO) {
    let res: any;
    let page = Number(queryVO.page);
    let size = Number(queryVO.size);
    let account_type = Number(queryVO.account_type);
    let user_id = Number(queryVO.user_id);
    let symbol = queryVO.symbol;
    let from_time = queryVO.from_time;
    let to_time = queryVO.to_time;
    let type = queryVO.type;
    let bill_type_arr: any = [];
    if (type) {
        let split = type.split(',');
        for (let oneType of split) {
            bill_type_arr.push(Number(oneType));
        }
    }
    if (account_type == 1) {//钱包账户
        res = await getMainBills(user_id, symbol, from_time, to_time, bill_type_arr, page, size);
    }
    else {
        res = await getTradeBills(user_id, symbol, from_time, to_time, bill_type_arr, page, size);
    }
    return res;
}


async function getBillTypesMap() {
    //用的地方少 这里就不生成dao 文件了
    let sql = `SELECT bill_type, bill_info_alias
               FROM bills_define_tree_new
               WHERE bill_type > -1`;

    let typeList = await ormDB.query(sql, { raw: true, type: ormDB.QueryTypes.SELECT });
    let map: any = {};
    for (let item of typeList) {
        map[item.bill_type] = item.bill_info_alias;
    }
    return map;
}


async function getMainBills(user_id: number, symbol: string, from_time: any, to_time: any, bill_type_arr: any, page: number, size: number) {

    let condition = {
        user_id,
        createdAt: {
            [ormDB.Op.and]: [
                { [ormDB.Op.gte]: from_time },
                { [ormDB.Op.lt]: to_time }
            ]
        }
    }
    if (bill_type_arr.length) {
        condition['type'] = bill_type_arr;
    }
    if (symbol) {
        condition['symbol'] = symbol
    }
    let resList = await mainUserBills.prototype.findAndCount({
        attributes: ['user_id', 'symbol', ormDB.literal('type as bill_type'), ormDB.literal(' `change` as change_amount'), 'result', 'comment', 'createdAt'],
        where: condition,
        order: [['id', 'desc']],
        limit: size,
        offset: page * size - size,
        raw: true
    });
    return resList;
}

async function getTradeBills(user_id: number, symbol: string, from_time: any, to_time: any, bill_type_arr: any, page: number, size: number) {
    let condition = {
        user_id,
        time: {
            [dwdMadOrmDB.Op.and]: [
                { [dwdMadOrmDB.Op.gte]: new Date(from_time).getTime() },
                { [dwdMadOrmDB.Op.lt]: new Date(to_time).getTime() }
            ]
        }
    }
    if (bill_type_arr.length) {
        condition['type'] = bill_type_arr;
    }
    if (symbol) {
        condition['asset'] = symbol
    }
    let resList = await dwdExLedger.prototype.findAndCount({
        attributes: ['user_id', dwdMadOrmDB.literal('asset as symbol'), dwdMadOrmDB.literal('type as bill_type'), dwdMadOrmDB.literal('amount as change_amount'), dwdMadOrmDB.literal('balance as result'), 'comment', 'createdAt'],
        where: condition,
        order: [['ledger_id', 'desc']],
        limit: size,
        offset: page * size - size,
        raw: true
    });
    return resList;
}








