// 每日定时统计项目方 指定交易对做市信息,
// 并根据成交量信息判断是否满足承诺交易量
// 不满足则将费率降为基础费率;
import {
    ormDB, commonUserFeeSetting, feeRateSpotLog, userInfoSon, spotPairs, contractPairs, userInfo,
    dwdExFill, dwdMadOrmDB
} from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";
import * as RobotUtil from "../../src/utils/robotUtils";

let Op = ormDB.Op;
let { tickerUtils, redisUtilsCommon } = require('@madex/ex-js-common');
let user_info_son = userInfoSon.prototype;
let user_info = userInfo.prototype;
const SonStatus = userInfoSon.STATUS;

const logger = require('@madex/ex-js-public').logger;
let feeRateCheckStatus = FEE_RATE_LOG_STATUS;


const DAY = 24 * 3600 * 1000;

const FEE_MODEL = {
    "fixedingain": "fixedingain"
}
const Market_Maker_FEE = {
    init_taker: 0.002,
    init_maker: 0.001,
}

async function delayPromise(time: any) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

export const statisticsProjectMakerDeals = async function (now = Date.now()) {
    try {
        let ticker_map: any = {};
        let users = await projectMaker();
        // 当前统计昨天的成交数据
        let startTime = now - now % DAY - DAY;
        // { father_id_pair: {maker, taker}}
        let fatherFeeObj = {};
        for (let i = 0; i < users.length; i++) {

            let { user_id, pair, status, statis_period, amount_require_usdt, maker_fee, taker_fee } = users[i];
            if (pair == 'all') {
                let msg = `统计项目方交易量发生错误:user_id:${user_id},pair:${pair}`;
                logger.error(msg);
                RobotUtil.sendRobotMessage(RobotUtil.ROBOT_KEYS.COMMON_KEY, msg);
                continue;
            }
            if (user_id && pair) {
                //取汇率
                let coin_symbol = pair.split('_')[0];
                let coin_symbol_usdt_rate = ticker_map[coin_symbol] ? ticker_map[coin_symbol] : await tickerUtils.rateCoin2USDT(coin_symbol);
                ticker_map[coin_symbol] = coin_symbol_usdt_rate;
                let redisKey = user_id + "_" + pair + "_projectMaker_FeeRate";
                await delayPromise(100);
                let statisUsdt = await statisUserPairSpot(user_id, pair, startTime, coin_symbol_usdt_rate);
                let feeObjUsdt = getUserFeeRateFromUsdtStatis(statisUsdt, statis_period, amount_require_usdt, taker_fee, maker_fee);
                await adjustMakerFeeRate(now, user_id, pair, status, feeObjUsdt, fatherFeeObj);
                redisUtilsCommon.write(redisKey, JSON.stringify(Object.assign({}, feeObjUsdt)), 0, () => {
                });
            }

        }
        now = Date.now();
        let expired = now + DAY - 30000;
        for (let key in fatherFeeObj) {
            let [user_id, pair] = key.split('@');
            let fatherFee = fatherFeeObj[key];
            if (fatherFee) {
                let { maker_fee, taker_fee } = fatherFee;
                await setExpiredFeeSettingActiveOver(user_id, pair);
                await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, maker_fee, taker_fee, now, expired, "项目方做市商策略根据子账户交易量设置父账户费率");
            }
        }
    }
    catch (error) {
        logger.warn(' statisProjectMakerDeals error ', error);
    }
}

/**
 * 查询项目方 （只有现货的）
 */
async function projectMaker() {
    let res: any = [];
    try {
        res = await commonUserFeeSetting.prototype.findAll({
            where: {
                user_channel: 2,//项目方
                type: 1,//现货
                status: 2,//已生效
            },
            order: [['id', 'asc']],
            raw:
                true,
        })
        ;
    }
    catch (error) {
        logger.warn(' 获取项目方做市商 projectMaker error', error);
    }
    return res;
}


// 统计币币成交量信息
async function statisUserPairSpot(user_id: number, pair: string, timestamp: any, coin_symbol_usdt_rate: any) {
    let redisKeyUsdt = user_id + "_" + pair + '_projectMaker_spot_usdt';
    let resultCacheInUsdt = {};
    try {
        let resultCacheInUsdt = await redisUtilsCommon.getSync(redisKeyUsdt);
        let usdtAmount = await getDealOneDay(pair, new Date(timestamp), timestamp + DAY, coin_symbol_usdt_rate);
        resultCacheInUsdt = updateCache(resultCacheInUsdt, timestamp, usdtAmount);
        redisUtilsCommon.write(redisKeyUsdt, JSON.stringify(resultCacheInUsdt), 0, () => {
        });
    }
    catch (error) {
        logger.warn(' 统计项目做市上成交总和 error ', error);
    }
    return resultCacheInUsdt;
}

// 获取昨天一天的的统计交易量
// 该交易对对所有交易量都归该做市帐号
async function getDealOneDay(pair: string, startTime: any, endTime: any, coin_symbol_usdt_rate: any) {
    let resCountInUsdt = 0;
    try {
        let dbOne = await dwdExFill.prototype.findOne({
            attributes: ['product', dwdMadOrmDB.literal('SUM(ABS(quantity)) as quantity')],
            where: {
                product: pair,
                time: {
                    [dwdMadOrmDB.Op.gte]: startTime,
                    [dwdMadOrmDB.Op.lt]: endTime,
                }
            },
            group: ['product'],
            raw: true
        });

        if (dbOne && dbOne.quantity > 0.00000001) {
            let equalUsdt = dbOne.quantity * coin_symbol_usdt_rate;
            if (equalUsdt >= 0.00000001) {
                resCountInUsdt = equalUsdt;
            }
        }
    }
    catch (error) {
        logger.error(" 查询用户每天做市量出错 ", error);
    }
    return resCountInUsdt;
}


function updateCache(resultCache: any, timestamp: any, userDeals: any) {
    if (resultCache) {
        let timesArr = Object.keys(resultCache);
        if (!timesArr.includes(String(timestamp)) && userDeals > 0) {//是否存在今天的数据
            resultCache[timestamp] = userDeals;
        }
        if (timesArr.length > 31) {
            for (let i = 0, len = timesArr.length - 31; i < len; i++) {
                if (timestamp - Number(timesArr[i]) > 31 * DAY) { // 删除超过30天的缓存数据
                    delete resultCache[timesArr[i]];
                }
            }
        }
    }
    else { // 无缓存数据
        if (userDeals > 0) {
            resultCache = {
                [timestamp]: userDeals
            }
        }
    }
    return Object.assign({}, resultCache);
}


//从统计结果中获取用户费率， usdt统计
function getUserFeeRateFromUsdtStatis(dealAmount: any, statis_period: any, requireAmount: any, taker_fee: any, maker_fee: any) {
    let timeArr = Object.keys(dealAmount), len = timeArr.length, canAjustFeeRateUsdt = false, sum = 0, avg = 0;
    let taker_rate = taker_fee, maker_rate = maker_fee;
    //未到统计周期 按原来设置的费率走
    if (len > 0 && len < statis_period) {
        for (let i = 0; i < len; i++) {
            let ts = timeArr[i];
            sum += Number(dealAmount[ts]) || 0;
        }
        avg = sum / len;
    }
    else if (len >= statis_period) {
        sum = 0;
        for (let i = len - 1, stopIndex = len - statis_period; i >= stopIndex; i--) {
            let ts = timeArr[i];
            sum += Number(dealAmount[ts]) || 0;
        }
        avg = sum / statis_period;
        //到达统计周期 但是不满足 承诺交易量
        if (avg < requireAmount) {
            //需要调整为普通费率
            canAjustFeeRateUsdt = true;
            taker_rate = Market_Maker_FEE.init_taker;
            maker_rate = Market_Maker_FEE.init_maker;
        }
    }
    return { taker_rate, maker_rate, avg_usdt: avg, canAjustFeeRateUsdt };
}


// 调整做市商费率最佳
async function adjustMakerFeeRate(now: any, user_id: any, pair: any, status: any, feeObjUsdt: any = {}, fatherFeeObj: any = {}) {
    // let now = Date.now();
    let expired = new Date(now).getTime() + DAY - 30000; // 有效期提前30s,早于新费率开始时间
    console.error(' 执行项目做市商 uid %s ,  %s  费率调整 ', user_id, pair);
    //status 2 生效时才统计
    if (Number(status) == 2) {
        if (feeObjUsdt && feeObjUsdt.canAjustFeeRateUsdt) {
            console.error(' 新做市策略 ', JSON.stringify(feeObjUsdt));
            let taker_fee = feeObjUsdt.taker_rate;
            let maker_fee = feeObjUsdt.maker_rate;
            await storeFatherFeeSet(user_id, pair, maker_fee, taker_fee, fatherFeeObj);
            await setExpiredFeeSettingActiveOver(user_id, pair);
            return await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, maker_fee, taker_fee, now, expired, "项目方做市商根据usdt成交量自动调整");
        }
    }

}


async function storeFatherFeeSet(user_id: any, pair: any, maker_fee: any, taker_fee: any, fatherFeeObj = {}) {
    let fatherObj = await getFatherUID(user_id);
    if (fatherObj && fatherObj.father_id) {
        let key = fatherObj.father_id + "@" + pair;
        if (!fatherFeeObj[key]) {
            fatherFeeObj[key] = {
                pair,
                maker_fee,
                taker_fee
            }
        }
        else {
            fatherFeeObj[key] = {
                pair,
                maker_fee: Math.min(maker_fee, fatherFeeObj[key].maker_fee),
                taker_fee: Math.min(taker_fee, fatherFeeObj[key].taker_fee),
            }
        }
    }
    logger.info(' father fee setting ', JSON.stringify(fatherFeeObj));
}


// 获取某个子账户的父账户
async function getFatherUID(user_id: any) {
    return user_info_son.findOne({
        attributes: ['father_id'],
        where: {
            user_id,
            status: SonStatus.NORMAL,
        },
        raw: true,
    });
}


// 将即过期默认为生效的置为生效完成， 防止覆盖新的费率
async function setExpiredFeeSettingActiveOver(user_id: any, pair: any) {
    try {
        let now = new Date();
        // console.log(' 更新做市商即将到期生效的费率', user_id, pair);
        let res = await feeRateSpotLog.prototype.update({
            is_check: feeRateSpotLog.IS_CHECK.ActiveOver,
        }, {
            where: {
                user_id: user_id,
                pair: pair,
                is_check: feeRateSpotLog.IS_CHECK.Uncheck,
                beginAt: {
                    [Op.gte]: now,
                    [Op.lt]: new Date(now.getTime() + 3600 * 1000)
                },
            }
        });
        // console.error(' 使当前未生效过期 res ', JSON.stringify(res));
    }
    catch (error) {
        logger.error(' make expried fee setting active_over: error ', error);
    }
}


async function addFeeRate(user_id: any, pair: any, fee_model: any, maker_fee: any, taker_fee: any, beginAt: any, expireAt: any, comment = '') {
    if (comment && String(comment).length > 512) {
        throw '3000';
    }
    let dbinfo = await user_info.findOne({
        where: {
            user_id: Number(user_id),
        },
        raw: true,
    });
    if (!dbinfo) {
        throw '3000';
    }
    let insertOne = {
        user_id, pair, fee_model, maker_fee, taker_fee, beginAt, expireAt,
        is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
        comment: String(comment),
    }
    await feeRateSpotLog.prototype.create(insertOne);
}