// 每日定时统计项目方 指定交易对做市信息, 并根据成交量信息进行费率分档优惠;
import { ormDB, commonUserFeeSetting, feeRateSpotLog, userInfoSon, spotPairs, contractPairs, userInfo } from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";

let Op = ormDB.Op;
let { tickerUtils, redisUtilsCommon } = require('@madex/ex-js-common');
let user_info_son = userInfoSon.prototype;
let user_info = userInfo.prototype;
const SonStatus = userInfoSon.STATUS;

const logger = require('@madex/ex-js-public').logger;
let feeRateCheckStatus = FEE_RATE_LOG_STATUS;

//对btc价格,缓存 {coinSymbol: priceInfo}
var price2BTC = {};

//价格缓存时间 2分钟
const CACHE_TIMEOUT = 2 * 60 * 1000;
const DAY = 24 * 3600 * 1000;

const FEE_MODEL = {
    "fixedingain": "fixedingain"
}
const BTC_AMOUNT = {
        "BTC30": 30,
        "BTC5": 5,
        "BTC0": 0,
    },
    FEE_RATE = {
        "Wan1": 0.0001,
        "Wan2": 0.0002,
        "Default": 0.001,
        "maker_default": 0.0008,
        "Free": 0,
    },
    Market_Maker_FEE = {
        init_taker: 0.0002,
        init_maker: 0,
    }

async function delayPromise(time) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

export const statisProjectMakerDeals = async function (now = Date.now()) {
    try {
        //TODO：按之前代码来看，只有现货相关的，这里怎么做
        let users = await projectMaker();
        let startTime = now - now % DAY - DAY;// 当前统计昨天的成交数据
        let btc2usdt = await getDealOneDayInUSDT(startTime, startTime + DAY);
        let fatherFeeObj = {}; // { fatherid_pair: {maker, taker}}
        for (let i = 0; i < users.length; i++) {
            let { user_id, pair, status, statis_period, amount_require_usdt, type } = users[i]; //status 2 生效时才统计
            let pairs = pair == 'all' ? await getPairsByType(type) : [pair];
            for (let onePair of pairs) {
                if (user_id && onePair) {
                    let redisKey = user_id + "_" + onePair + "_projectMaker_FeeRate";
                    await delayPromise(100);
                    let [statis, statisUsdt] = await statisUserPairSpot(user_id, onePair, startTime, btc2usdt);
                    let feeObjBtc = getUserFeeRateFromStatis(statis); // old
                    let feeObjUsdt = getUserFeeRateFromUsdtStatis(statisUsdt, statis_period, amount_require_usdt)
                    await adjustMakerFeeRate(now, user_id, onePair, status, feeObjBtc, feeObjUsdt, fatherFeeObj);
                    redisUtilsCommon.write(redisKey, JSON.stringify(Object.assign({}, feeObjUsdt, feeObjBtc)), 0, () => {
                    });
                }
            }

        }
        now = Date.now();
        let expired = now + DAY - 30000;
        for (let key in fatherFeeObj) {
            let [user_id, pair] = key.split('@');
            let faterFee = fatherFeeObj[key];
            if (faterFee) {
                let { maker_fee, taker_fee } = faterFee;
                await setExpiredFeeSettingActiveOver(user_id, pair);
                await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, maker_fee, taker_fee, now, expired, Market_Maker_FEE.init_maker, Market_Maker_FEE.init_taker, "项目方做市商策略根据子账户交易量设置父账户费率");
            }
        }
    }
    catch (error) {
        logger.warn(' statisProjectMakerDeals error ', error);
    }
}

// 统计 项目方 7日, 15日 指定币种对 做市
async function projectMaker() {
    let res: any = [];
    try {
        res = await commonUserFeeSetting.prototype.findAll({
            where: {
                user_channel: 2,
                type: 1,
            },
            order: [['id', 'asc']],
            raw:
                true,
        })
        ;
    }
    catch (error) {
        logger.warn(' 获取项目方做市商 projectMaker error', error);
    }
    return res;
}

// 获取交易对USDT交易量
async function getDealOneDayInUSDT(startTime, endTime) {
    let price = await tickerUtils.rateCoin2USDT('BTC');
    //TODO:查哪里？？？
    /*let priceRes = await ex_kline.find({
        attributes: [[ormDBSpot.literal('AVG(close)'), 'closePrice']],
        where: {
            pair: "BTC_USDT",
            period: '1hour',
            createdAt: {
                [Op.gte]: new Date(startTime),
                [Op.lt]: new Date(endTime),
            }
        },
        raw: true,
    });
    if(priceRes && Number(priceRes.closePrice) > 0) {
        price = Number(priceRes.closePrice).toFixed(4);
    }*/
    return Number(price);
}

// 统计币币成交量信息
async function statisUserPairSpot(user_id, pair, timestamp, btc2usdt) {
    let redisKey = user_id + "_" + pair + '_projectMaker_spot';
    let redisKeyUsdt = user_id + "_" + pair + '_projectMaker_spot_usdt';
    let resultCache = {}, resultCacheInUsdt = {};
    try {
        [resultCache, resultCacheInUsdt] = await Promise.all([redisUtilsCommon.getSync(redisKey), redisUtilsCommon.getSync(redisKeyUsdt)]);
        let userDeals = await getDealOneDay(pair, new Date(timestamp), timestamp + DAY);
        resultCache = updateCache(resultCache, timestamp, userDeals);
        let usdtAmount = Number(userDeals) * btc2usdt
        resultCacheInUsdt = updateCache(resultCacheInUsdt, timestamp, usdtAmount);
        redisUtilsCommon.write(redisKey, JSON.stringify(resultCache), 0, () => {
        });
        redisUtilsCommon.write(redisKeyUsdt, JSON.stringify(resultCacheInUsdt), 0, () => {
        });
    }
    catch (error) {
        logger.warn(' 统计项目做市上成交总和 error ', error);
    }
    return [resultCache, resultCacheInUsdt];
}

// 获取昨天一天的的统计交易量
// 该交易对对所有交易量都归该做市帐号
async function getDealOneDay(pair, startTime, endTime) {
    let resCountInBTC = 0;
    try {
        //查哪里
        /*let tradeDetail = await ex_trade_detail_spot.find({
            attributes: ['currency_symbol', [ormDBSpot.literal('SUM(deal_money)'), 'deal_money']],
            where: {
                pair: pair,
                createdAt: {
                    [Op.gte]: startTime,
                    [Op.lt]: endTime,
                }
            },
            group: ['currency_symbol'],
            raw: true,
        });
        if (tradeDetail && tradeDetail.deal_money > 0.00000001) {
            let currencySymbol = tradeDetail.currency_symbol;
            let currencyAmount = tradeDetail.deal_money;
            let price = await coinPriceInBTC(currencySymbol, startTime, endTime);
            let equalBTC = currencyAmount * price;
            // let equalBTC = currencyAmount * 0.001;
            if (equalBTC >= 0.00000001) {
                resCountInBTC = equalBTC;
            }
        }*/
    }
    catch (error) {
        logger.error(" 查询用户每天做市量出错 ", error);
    }
    return resCountInBTC;
}


async function coinPriceInBTC(coinSymbol, startTime, endTime) {
    let time = Date.now();
    if (!coinSymbol) {
        logger.error(' coinSymbol illegal, coinSymbol is: ', coinSymbol);
    }
    let priceInfo = price2BTC[coinSymbol];
    if (coinSymbol === 'BTC') {
        //BTC无转换
        return 1;
    }
    else if (priceInfo && (time - priceInfo.updatedTime) <= CACHE_TIMEOUT) {
        return priceInfo.price;
    }
    else {
        //拉取24小时平均价格
        let tickerPair, lastPrice = 0;
        if (coinSymbol === 'USDT' || coinSymbol === 'DAI' || coinSymbol === 'GUSD') {
            tickerPair = 'BTC_' + coinSymbol;
        }
        else {
            tickerPair = coinSymbol + '_BTC';
        }
        try {
            //TODO:查哪里
            /*let priceRes = await ex_kline.find({
                attributes: [[ormDBSpot.literal('AVG(close)'), 'closePrice']],
                where: {
                    pair: tickerPair,
                    period: '1hour',
                    createdAt: {
                        [Op.gte]: startTime,
                        [Op.lt]: endTime,
                    }
                },
                raw: true,
            });
            if (priceRes && priceRes.closePrice > 0) {
                if (coinSymbol === 'USDT' || coinSymbol === 'DAI' || coinSymbol === 'GUSD') {
                    lastPrice = 1 / priceRes.closePrice;
                } else {
                    lastPrice = priceRes.closePrice;
                }
                price2BTC[coinSymbol] = { updatedTime: Date.now(), price: lastPrice };
            } else {
                logger.warn(` 未查询到交易对${tickerPair} 24hour均值`, priceRes);
            }*/
            return lastPrice;
        }
        catch (error) {
            logger.warn(` 查询到交易对${tickerPair} 24hour均值出错 `, error);
            price2BTC[coinSymbol] = { updatedTime: Date.now(), price: 0 };
            return 0;
        }
    }
}


function updateCache(resultCache, timestamp, userDeals) {
    if (resultCache) {
        let timesArr = Object.keys(resultCache);
        if (!timesArr.includes(String(timestamp)) && userDeals > 0) {//是否存在今天的数据
            resultCache[timestamp] = userDeals;
        }
        if (timesArr.length > 31) {
            for (let i = 0, len = timesArr.length - 31; i < len; i++) {
                if (timestamp - Number(timesArr[i]) > 31 * DAY) { // 删除超过30天的缓存数据
                    delete resultCache[timesArr[i]];
                }
            }
        }
    }
    else { // 无缓存数据
        if (userDeals > 0) {
            resultCache = {
                [timestamp]: userDeals
            }
        }
    }
    return Object.assign({}, resultCache);
}


// 从统计结果中获取用户费率， 旧btc交易量统计会逐渐改为usdt统计
function getUserFeeRateFromStatis(dealAmountCache) {
    let feeRate = FEE_RATE.Default, avg7 = 0, avg15 = 0, canAjustFeeRateBTC = false;
    try {
        const day7 = 7, day15 = 15;
        let timeArr = Object.keys(dealAmountCache), len = timeArr.length, sum;
        let feeRate7 = FEE_RATE.Default, feeRate15 = FEE_RATE.Default;
        if (len > 0 && len < day7) {// 低于 7 天
            sum = 0;
            for (let i = 0; i < len; i++) {
                let ts = timeArr[i];
                sum += Number(dealAmountCache[ts]) || 0;
            }
            avg7 = sum / len;
        }
        if (len >= day7) {
            canAjustFeeRateBTC = true;
            sum = 0;
            for (let i = len - 1, stopIndex = len - day7; i >= stopIndex; i--) {
                let ts = timeArr[i];
                sum += Number(dealAmountCache[ts]) || 0;
            }
            avg7 = sum / day7;
            if (avg7 >= BTC_AMOUNT.BTC30) {
                feeRate7 = FEE_RATE.Wan1;
            }
            else if (avg7 >= BTC_AMOUNT.BTC5) {
                feeRate7 = FEE_RATE.Wan2;
            }
            else if (avg7 > BTC_AMOUNT.BTC0) {
                feeRate7 = FEE_RATE.Default;
            }
        }

        if (len >= day15) {
            sum = 0;
            for (let i = len - 1, stopIndex = len - day15; i >= stopIndex; i--) {
                let ts = timeArr[i];
                sum += Number(dealAmountCache[ts]) || 0;
            }
            avg15 = sum / day15;
            if (avg15 >= BTC_AMOUNT.BTC30) {
                feeRate15 = FEE_RATE.Free;
            }
            else if (avg15 >= BTC_AMOUNT.BTC5) {
                feeRate15 = FEE_RATE.Wan2;
            }
            else if (avg15 > BTC_AMOUNT.BTC0) {
                feeRate15 = FEE_RATE.Default;
            }
        }
        feeRate = Math.min(feeRate7, feeRate15);
    }
    catch (error) {
        logger.warn(' getUserFeeRateFromStatis error', error);
    }
    return { feeRate, avg7, avg15, canAjustFeeRateBTC };
}


// 增加usdt统计需求，
function getUserFeeRateFromUsdtStatis(dealAmount, statis_period, requireAmount = 100000) {
    let timeArr = Object.keys(dealAmount), len = timeArr.length, canAjustFeeRateUsdt = false, sum = 0, avg = 0;
    let taker_rate = 0.0002, maker_rate = 0; // 新项目做市商需求，如果<100K， taker 0.02%, maker = 0;
    if (len > 0 && len < statis_period) {
        for (let i = 0; i < len; i++) {
            let ts = timeArr[i];
            sum += Number(dealAmount[ts]) || 0;
        }
        avg = sum / len;
    }
    else if (len >= statis_period) {
        canAjustFeeRateUsdt = true;
        sum = 0;
        for (let i = len - 1, stopIndex = len - statis_period; i >= stopIndex; i--) {
            let ts = timeArr[i];
            sum += Number(dealAmount[ts]) || 0;
        }
        avg = sum / statis_period;
        if (avg >= requireAmount) {
            taker_rate = 0;
        }
    }
    return { taker_rate, maker_rate, avg_usdt: avg, canAjustFeeRateUsdt };
}


// 调整做市商费率最佳
async function adjustMakerFeeRate(now, user_id, pair, enableAjustFee, feeObjBtc: any = {}, feeObjUsdt: any = {}, fatherFeeObj: any = {}) {
    // let now = Date.now();
    let expired = new Date(now).getTime() + DAY - 30000; // 有效期提前30s,早于新费率开始时间
    console.error(' 执行项目做市商 uid %s ,  %s  费率调整 ', user_id, pair);
    let maker_fee = Market_Maker_FEE.init_maker, taker_fee = Market_Maker_FEE.init_taker;
    let { maker, taker } = await getProjectSpotFeeRate(user_id, pair, now - 3600000);// 查询费率变更前的费率 0 则继续免费
    if (enableAjustFee) {
        if (feeObjUsdt && feeObjUsdt.canAjustFeeRateUsdt) { // 新版usdt计量策略优先
            console.error(' 新做市策略 ', JSON.stringify(feeObjUsdt));
            if (taker_fee > feeObjUsdt.taker_rate) {  // taker_rate, maker_rate,
                taker_fee = feeObjUsdt.taker_rate;
            }
            if (maker_fee > feeObjUsdt.maker_rate) {
                maker_fee = feeObjUsdt.maker_rate;
            }
            await storeFatherFeeSet(user_id, pair, maker_fee, taker_fee, fatherFeeObj);
            await setExpiredFeeSettingActiveOver(user_id, pair);
            return await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, maker_fee, taker_fee, now, expired, Market_Maker_FEE.init_maker, Market_Maker_FEE.init_taker, "项目方做市商根据usdt成交量自动调整");
        }
        else if (feeObjBtc && feeObjBtc.canAjustFeeRateBTC) { // 执行老版 btc 计量策略
            console.error(' 早期做市策略 ', JSON.stringify(feeObjBtc));
            if (maker == FEE_RATE.Free && taker == FEE_RATE.Free && feeObjBtc.feeRate == FEE_RATE.Wan1) {//手动设置，默认免手续费；若项目单个交易对连续7天日均交易量达到30BTC以上，该交易对手续费保持免费；(运营加需求)
                await storeFatherFeeSet(user_id, pair, FEE_RATE.Free, FEE_RATE.Free, fatherFeeObj);
                await setExpiredFeeSettingActiveOver(user_id, pair);
                return await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, FEE_RATE.Free, FEE_RATE.Free, now, expired, Market_Maker_FEE.init_maker, Market_Maker_FEE.init_taker, "项目方做市商根据btc成交量自动调整");
            }
            else {
                console.error(' 早期做市策略 ', JSON.stringify(feeObjBtc));
                //  maker_fee = feeObjBtc.feeRate, taker_fee = feeObjBtc.feeRate;
                maker_fee = Math.min(maker_fee, feeObjBtc.feeRate), taker_fee = Math.min(taker_fee, feeObjBtc.feeRate);
                await storeFatherFeeSet(user_id, pair, maker_fee, taker_fee, fatherFeeObj);
                await setExpiredFeeSettingActiveOver(user_id, pair);
                return await addFeeRate(user_id, pair, FEE_MODEL.fixedingain, maker_fee, taker_fee, now, expired, Market_Maker_FEE.init_maker, Market_Maker_FEE.init_taker, "项目方做市商策略根据btc成交量自动调整");
            }

        }
    }

}


/**
 * 如果用户设置前7日>30BTC并且享受免费， 则一直为免费
 * @param {*} user_id
 * @param {*} pair
 * @param {*} time
 */
async function getProjectSpotFeeRate(user_id, pair, time) {
    let maker = FEE_RATE.maker_default, taker = FEE_RATE.Default;
    try {
        let res = await feeRateSpotLog.prototype.findOne({
            attributes: ['maker_fee', 'taker_fee'],
            where: {
                user_id: user_id,
                pair: pair,
                is_check: 1,
                beginAt: { [Op.lt]: new Date(time), },
                expireAt: { [Op.gte]: new Date(time), }
            },
            raw: true,
        });
        if (res && Number(res.maker_fee) >= 0 && Number(res.taker_fee) >= 0) {
            maker = Number(res.maker_fee);
            taker = Number(res.taker_fee);
        }
    }
    catch (error) {
        logger.warn(' marketMarkerMgr.service  ', error);
    }
    return {
        taker,
        maker,
    }
}

async function storeFatherFeeSet(user_id, pair, maker_fee, taker_fee, fatherFeeObj = {}) {
    let faterObj = await getFaterUID(user_id);
    if (faterObj && faterObj.father_id) {
        let key = faterObj.father_id + "@" + pair;
        if (!fatherFeeObj[key]) {
            fatherFeeObj[key] = {
                pair,
                maker_fee,
                taker_fee
            }
        }
        else {
            fatherFeeObj[key] = {
                pair,
                maker_fee: Math.min(maker_fee, fatherFeeObj[key].maker_fee),
                taker_fee: Math.min(taker_fee, fatherFeeObj[key].taker_fee),
            }
        }
    }
    logger.info(' father fee setting ', JSON.stringify(fatherFeeObj));
}


// 获取某个子账户的父账户
async function getFaterUID(user_id) {
    return user_info_son.findOne({
        attributes: ['father_id'],
        where: {
            user_id,
            status: SonStatus.NORMAL,
        },
        raw: true,
    });
}


// 将即过期默认为生效的置为生效完成， 防止覆盖新的费率
async function setExpiredFeeSettingActiveOver(user_id, pair) {
    try {
        let now = new Date();
        // console.log(' 更新做市商即将到期生效的费率', user_id, pair);
        let res = await feeRateSpotLog.prototype.update({
            is_check: feeRateSpotLog.IS_CHECK.ActiveOver,
        }, {
            where: {
                user_id: user_id,
                pair: pair,
                is_check: feeRateSpotLog.IS_CHECK.Uncheck,
                beginAt: {
                    [Op.gte]: now,
                    [Op.lt]: new Date(now.getTime() + 3600 * 1000)
                },
            }
        });
        // console.error(' 使当前未生效过期 res ', JSON.stringify(res));
    }
    catch (error) {
        logger.error(' make expried fee setting active_over: error ', error);
    }
}

async function getPairsByType(type: number) {
    let dbList: any;
    //现货
    if (type == 1) {
        dbList = await spotPairs.prototype.findAll({
            where: { status: 2 },
            raw: true
        });
    }
    else {
        dbList = await contractPairs.prototype.findAll({
            where: { status: 2 },
            raw: true
        });
    }
    return dbList.map(item => item.symbol);
}

async function addFeeRate(user_id, pair, fee_model, maker_fee, taker_fee, beginAt, expireAt, maker_fee_late, taker_fee_late, comment = '') {
    if (comment && String(comment).length > 512) {
        throw '3000';
    }
    let dbinfo = await user_info.findOne({
        where: {
            user_id: Number(user_id),
        },
        raw: true,
    });
    if (!dbinfo) {
        throw '3000';
    }
    let insertOne = {
        user_id, pair, fee_model, maker_fee, taker_fee, beginAt, expireAt,
        is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
        comment: String(comment),
    }
    await feeRateSpotLog.prototype.create(insertOne);
}