import * as service from "../service/contractPair.service";
import { AddParam, ListParam } from "../service/contractPair.service";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
let isIp = require('is-ip');


export const list = async (req: any, param: ListParam) => {
    let func_name = "contactPairCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.list(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
//新增
export const save = async (req: any, param: AddParam) => {
    let func_name = "contactPairCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.index);
        ApiAssert.notNull('3000', param.settlement_asset);
        ApiAssert.notNull('3000', param.price_scale);
        ApiAssert.notNull('3000', param.quantity_scale);
        ApiAssert.notNull('3000', param.maker_fee);
        ApiAssert.notNull('3000', param.taker_fee);
        ApiAssert.notNull('3000', param.default_initial_margin);
        ApiAssert.notNull('3000', param.base_initial_margin);
        ApiAssert.notNull('3000', param.base_maintenance_margin);
        ApiAssert.notNull('3000', param.base_interest);
        ApiAssert.notNull('3000', param.quote_interest);
        ApiAssert.notNull('3000', param.impact_notional);
        ApiAssert.notNull('3000', param.base_risk_limit);
        ApiAssert.notNull('3000', param.risk_limit_step);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.save(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
//修改
export const update = async (req: any, param: AddParam) => {
    let func_name = "contactPairCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.update(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

//提交到撮合
export const pushToCoreSystem = async (req: any, param: AddParam) => {
    let func_name = "contactPairCtl.pushToCoreSystem";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.pushToCoreSystem(param.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const getAllSubmitSuccess = async (req: any, param: ListParam) => {
    let func_name = "contactPairCtl.getAllSubmitSuccess";
    let cmd = req.path;
    try {
        let res = await service.getAllSubmitSuccess();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
