import * as ReqUtils from "./req-utils";
import { ErrorCode } from "../constant/errorCode";
import { aclUserInfo } from "@madex/ex-ts-dao";
let { logger } = require("@madex/ex-js-public");
import { AclUserInfoConst } from "../constant/aclUserConstant";

/**
 * 获取当前登陆用户信息
 * @param sessionId
 */
export const getCurrentUser = async function (sessionId: string) {
    let currentUser = await ReqUtils.getCookie(sessionId);
    return currentUser;
}
/**
 * 获取当前登陆用户userId
 * @param sessionId
 */
export const getCurrentUserId = async function (sessionId: string) {
    let currentUser = await ReqUtils.getCookie(sessionId);
    return currentUser.userId;
}

/**
 * 判断是否是超管 通过 UID
 * @param user_id
 */
export const isAdminUserByUid = async function (user_id: number) {
    let dbInfo = await getOneAclUserByUid(user_id);
    if (dbInfo.user_type != AclUserInfoConst.USER_TYPE.ADMIN) {
        throw ErrorCode.NO_PERMISSION
    }
}

/**
 * 判断是否是超管 通过 session_id
 * @param sessionId
 */
export const isAdminUserBySessionId = async function (sessionId: string) {
    let currentUserId = await getCurrentUserId(sessionId);
    let dbInfo = await getOneAclUserByUid(currentUserId);
    if (dbInfo.user_type != AclUserInfoConst.USER_TYPE.ADMIN) {
        throw ErrorCode.NO_PERMISSION
    }
}
/**
 * 通过 user_id 查询用户
 * @param user_id
 */
export const getOneAclUserByUid = async function (user_id: number) {
    if (!user_id) {
        logger.error('aclUserUtils.getOneAclUserByUid.error:' + 'user_id is null');
        throw ErrorCode.PARAM_MISS
    }
    let dbInfo = await aclUserInfo.prototype.findOne({
        where: {
            user_id: user_id,
        },
        raw: true
    });
    if (!dbInfo) {
        logger.error('aclUserUtils.getOneAclUserByUid.error:' + 'dbInfo is null');
        throw ErrorCode.USER_NOT_EXIST
    }
    return dbInfo;
}
/**
 * 通过 account 查询用户
 * @param account
 */
export const getOneAclUserByAccount = async function (account: string) {
    if (!account) {
        logger.error('aclUserUtils.getOneAclUserByAccount.error:' + 'account is null');
        throw ErrorCode.PARAM_MISS
    }
    let dbInfo = await aclUserInfo.prototype.findOne({
        where: {
            account: account,
        },
        raw: true
    });
    if (!dbInfo) {
        logger.error('aclUserUtils.getOneAclUserByAccount.error:' + 'dbInfo is null');
        throw ErrorCode.USER_NOT_EXIST
    }
    return dbInfo;
}