import * as aclDepartmentService from "../service/aclDepartment.service";
import { AclDepartmentVO, AclDepartmentPageVO } from "../service/aclDepartment.service";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";
import { ErrorCode } from "../../../constant/errorCode";

let isIp = require('is-ip');
let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

/**
 * 分页查询部门列表
 * @param req
 * @param infoVO
 */
export const pageList = async (req: any, aclDepartmentPageVO: AclDepartmentPageVO) => {
    let func_name = "aclDepartmentCtrl.pageList";
    try {
        aclDepartmentPageVO.page = Optional.opt(aclDepartmentPageVO, 'page', 1);
        aclDepartmentPageVO.size = Optional.opt(aclDepartmentPageVO, 'size', 20);
        let res = await aclDepartmentService.pageList(aclDepartmentPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 查询所有部门列表
 * @param req
 * @param infoVO
 */
export const allList = async (req: any, aclDepartmentPageVO: AclDepartmentPageVO) => {
    let func_name = "aclDepartmentCtrl.allList";
    try {
        let res = await aclDepartmentService.allList();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 部门树
 * @param req
 * @param infoVO
 */
export const getDepartmentTree = async (req: any, aclDepartmentPageVO: AclDepartmentPageVO) => {
    let func_name = "aclDepartmentCtrl.getDepartmentTree";
    let cmd = req.path;
    try {
        let res = await aclDepartmentService.getDepartmentTree();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加部门
 * @param req
 * @param aclDepartmentVO
 */
export const add = async (req: any, aclDepartmentVO: AclDepartmentVO) => {
    let func_name = "aclDepartmentCtrl.add";
    let cmd = req.path;
    try {
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let res = await aclDepartmentService.add(aclDepartmentVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 修改部门
 * @param req
 * @param aclDepartmentVO
 */
export const update = async (req: any, aclDepartmentVO: AclDepartmentVO) => {
    let func_name = "aclDepartmentCtrl.update";
    let cmd = req.path;
    try {
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let res = await aclDepartmentService.update(aclDepartmentVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除部门
 * @param req
 * @param aclDepartmentVO
 */
export const del = async (req: any, aclDepartmentVO: AclDepartmentVO) => {
    let func_name = "aclDepartmentCtrl.del";
    let cmd = req.path;
    try {
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let res = await aclDepartmentService.del(Number(aclDepartmentVO.id), currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 根据部门IDS 或者user_id/邮箱/用户名 查询用户
 * @param req
 * @param infoVO
 */
export const getUserList = async (req: any, aclDepartmentPageVO: AclDepartmentPageVO) => {
    let func_name = "aclDepartmentCtrl.getUserList";
    try {
        aclDepartmentPageVO.page = Optional.opt(aclDepartmentPageVO, 'page', 1);
        aclDepartmentPageVO.size = Optional.opt(aclDepartmentPageVO, 'size', 20);

        let res = await aclDepartmentService.getUserList(aclDepartmentPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

