import { ormDB, usefulLink, userSub } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog, } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface QueryVO {
    id?: number;

    user_id?: number | any;

    is_kyc?: number;

    have_money?: number;

    page?: number,

    size?: number
}


export async function list(queryVO: QueryVO) {
    let where = Object.create(null);
    if (queryVO.user_id) {
        where.user_id = queryVO.user_id;
    }

    if (queryVO.is_kyc) {
        where.is_kyc = queryVO.is_kyc;
    }

    if (queryVO.have_money) {
        where.have_money = queryVO.have_money;
    }


    let resList = await userSub.prototype.findAndCount({
        where: where,
        limit: queryVO.size,
        offset: (Number(queryVO.page) - 1) * Number(queryVO.size),
        order: [["createdAt", "desc"]],
        raw: true
    });
    return resList;
}


export async function del(id: number, currentUserId: any, ip: string | undefined) {

    let dbInfo = await userSub.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });

    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST;
    }

    await userSub.prototype.update({
        status: 1,//0 有效 1 无效
    }, {
        where: {
            id: Number(id)
        }
    });
    //管理后台操作日志
    addOptLog(currentUserId, Number(dbInfo.user_id), '删除用户订阅', ip, dbInfo, '邮件和PUSH');
    return 'success'
}


export async function count() {
    let res = {
        money_and_kyc: 0,
        money_and_no_kyc: 0,
        no_money_and_kyc: 0,
        no_money_and_no_kyc: 0,
    }

    let dbInfoList = await userSub.prototype.findAll({
        where: {
            status: 0
        },
        raw: true
    });

    if (dbInfoList.length) {
        let kycMap = _.groupBy(dbInfoList, 'is_kyc');
        let throughList = kycMap["1"] ? kycMap["1"] : [];
        let noThroughList = kycMap["2"] ? kycMap["2"] : [];
        if (throughList.length) {
            let moneyMap = _.groupBy(throughList, 'have_money');
            res.money_and_kyc = moneyMap["1"] && moneyMap["1"].length ? moneyMap["1"].length : 0
            res.no_money_and_kyc = moneyMap["2"] && moneyMap["2"].length ? moneyMap["2"].length : 0
        }

        if (noThroughList.length) {
            let moneyMap = _.groupBy(noThroughList, 'have_money');
            res.money_and_no_kyc = moneyMap["1"] && moneyMap["1"].length ? moneyMap["1"].length : 0
            res.no_money_and_no_kyc = moneyMap["2"] && moneyMap["2"].length ? moneyMap["2"].length : 0
        }


    }
    return res;
}

